/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.csv;

import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.lib.csv.CsvCreator;
import de.mn77.lib.csv.CsvParser;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;

public class CsvTableFile {
    private Charset charset = null;
    private char delimiterColumn = (char)44;
    private char delimiterField = (char)34;
    private String delimiterLine = "\n";
    private final File file;

    public CsvTableFile(File f) {
        Err.ifNull((Object)f);
        this.file = f;
    }

    public CsvTableFile(I_File file) {
        this(file.getFile());
    }

    public CsvTableFile(String file) {
        this(new File(file));
    }

    public CsvTableFile append(I_Table<String> table) throws Err_FileSys {
        Err.ifNull(table);
        try {
            if (!this.file.exists()) {
                return this.write(table);
            }
            CsvCreator cc = new CsvCreator(this.delimiterField, this.delimiterColumn, this.delimiterLine);
            String s = String.valueOf(this.delimiterLine) + cc.compute(table);
            Lib_TextFile.append(this.file, s, this.charset);
        }
        catch (Exception err) {
            throw Err.fsAccess(err);
        }
        return this;
    }

    public Charset getCharset() {
        return this.charset == null ? Charset.defaultCharset() : this.charset;
    }

    public I_Table<String> read() throws Err_FileSys {
        String csv = Lib_TextFile.read(this.file, this.charset);
        return new CsvParser(this.delimiterField, this.delimiterColumn, this.delimiterLine).parse(csv, true, true);
    }

    public I_Table<String> readExceptFirstLine() throws Err_FileSys {
        String csv = Lib_TextFile.read(this.file, this.charset);
        return new CsvParser(this.delimiterField, this.delimiterColumn, this.delimiterLine).parse(csv, false, true);
    }

    public I_List<String> readFirstLine() throws Err_FileSys {
        String csv = Lib_TextFile.read(this.file, this.charset);
        I_Table<String> tab = new CsvParser(this.delimiterField, this.delimiterColumn, this.delimiterLine).parse(csv, true, false);
        Err.ifTooSmall(1.0, tab.size());
        String[] row = tab.getRow(0);
        SimpleList<String> list = new SimpleList<String>(row.length);
        list.addMore(row);
        return list;
    }

    public CsvTableFile setCharset(Charset cs) {
        this.charset = cs;
        return this;
    }

    public CsvTableFile setDelimiters(char field, char column, String line) {
        this.delimiterField = field;
        this.delimiterColumn = column;
        this.delimiterLine = line;
        return this;
    }

    public void write(I_List<String> head, I_Table<String> table) throws Err_FileSys {
        ArrayTable<String> tab = new ArrayTable<String>(head.size());
        tab.add((Collection<String>)head);
        tab.addAll(table);
        this.write(tab);
    }

    public CsvTableFile write(I_Table<String> table) throws Err_FileSys {
        Err.ifNull(table);
        try {
            if (this.file.exists()) {
                this.file.delete();
            }
            CsvCreator cc = new CsvCreator(this.delimiterField, this.delimiterColumn, this.delimiterLine);
            String data = cc.compute(table);
            Lib_TextFile.set(this.file, data, this.charset);
        }
        catch (Exception err) {
            throw Err.fsAccess(err);
        }
        return this;
    }
}

