/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.out;

import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.I_ErrorDetails;
import de.mn77.base.error.I_ErrorInfo;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.out.CHANNEL_IN;
import de.mn77.base.sys.out.CHANNEL_OUT;
import de.mn77.base.sys.out.MOutStyler;
import de.mn77.base.sys.out.OUTPUT_DETAIL;
import de.mn77.base.sys.out.OUTPUT_STYLE;
import de.mn77.base.sys.out.TRACE;
import java.io.File;
import java.util.ArrayList;

public class MOutWriter {
    private boolean outputDev = false;
    private boolean javaErrors = true;
    private String linebreak = System.lineSeparator();
    private File logFile = null;
    private CHANNEL_OUT[] routeDev = new CHANNEL_OUT[0];
    private CHANNEL_OUT[] routeErr = new CHANNEL_OUT[]{CHANNEL_OUT.STDERR, CHANNEL_OUT.LOG};
    private CHANNEL_OUT[] routeLog = new CHANNEL_OUT[]{CHANNEL_OUT.LOG};
    private CHANNEL_OUT[] routeOut = new CHANNEL_OUT[]{CHANNEL_OUT.STDOUT};
    private CHANNEL_OUT[] routeWrn = new CHANNEL_OUT[]{CHANNEL_OUT.LOG};
    private OUTPUT_STYLE style = OUTPUT_STYLE.RAW;
    private TRACE traceDefault = null;
    private final MOutStyler styler = new MOutStyler();
    private boolean useRoute = false;

    public synchronized void directErr(String s) {
        System.err.print(s);
    }

    public synchronized void directOut(String s) {
        System.out.print(s);
    }

    public boolean getJavaErrors() {
        return this.javaErrors;
    }

    public void routeDev(CHANNEL_OUT[] targets) {
        this.routeDev = targets;
        this.useRoute = true;
    }

    public void routeErr(CHANNEL_OUT[] targets) {
        this.routeErr = targets;
        this.useRoute = true;
    }

    public void routeLog(CHANNEL_OUT[] targets) {
        this.routeLog = targets;
        this.useRoute = true;
    }

    public void routeOut(CHANNEL_OUT[] targets) {
        this.routeOut = targets;
        this.useRoute = true;
    }

    public void routeWrn(CHANNEL_OUT[] targets) {
        this.routeWrn = targets;
        this.useRoute = true;
    }

    public void setDefaultTrace(TRACE trace) {
        this.traceDefault = trace;
    }

    public void setJavaErrors(boolean b) {
        this.javaErrors = b;
    }

    public void setLineBreak(String lb) {
        this.linebreak = lb;
        this.styler.setLineBreak(lb);
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public void setModeDeveloper() {
        this.outputDev = true;
    }

    public void setModeRaw() {
        this.outputDev = false;
    }

    public void setStyle(OUTPUT_STYLE style) {
        Err.ifNull((Object)style);
        this.style = style;
    }

    public void write(CHANNEL_IN channel, OUTPUT_DETAIL detail, TRACE trace, boolean error, boolean newLine, StackTraceElement[] ste, Object[] oa) {
        if (this.useRoute) {
            CHANNEL_OUT[] targets;
            CHANNEL_OUT[] cHANNEL_OUTArray = targets = channel == CHANNEL_IN.OUT ? this.routeOut : (channel == CHANNEL_IN.ERR ? this.routeErr : (channel == CHANNEL_IN.DEV ? this.routeDev : (channel == CHANNEL_IN.WRN ? this.routeWrn : this.routeLog)));
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                CHANNEL_OUT ch = cHANNEL_OUTArray[n2];
                if (ch == CHANNEL_OUT.STDOUT) {
                    this.writeStd(channel, detail, trace, error, newLine, ste, oa, false);
                } else if (ch == CHANNEL_OUT.STDERR) {
                    this.writeStd(channel, detail, trace, error, newLine, ste, oa, true);
                } else if (ch == CHANNEL_OUT.LOG) {
                    this.writeLog(channel, trace, error, ste, oa);
                }
                ++n2;
            }
        } else {
            switch (channel) {
                case OUT: {
                    this.writeStd(channel, detail, trace, error, newLine, ste, oa, false);
                    break;
                }
                case ERR: {
                    this.writeStd(channel, detail, trace, error, newLine, ste, oa, true);
                    this.writeLog(channel, trace, error, ste, oa);
                    break;
                }
                case WRN: {
                    if (this.outputDev) {
                        this.writeStd(channel, detail, trace, error, newLine, ste, oa, true);
                    }
                    this.writeLog(channel, trace, error, ste, oa);
                    break;
                }
                case DEV: {
                    if (!this.outputDev) break;
                    this.writeStd(channel, detail, trace, error, newLine, ste, oa, false);
                    break;
                }
                case LOG: {
                    this.writeLog(channel, trace, error, ste, oa);
                }
            }
        }
    }

    public void writeError(Throwable t, String text, boolean isCause) {
        if (t == null) {
            t = new RuntimeException();
        }
        StackTraceElement[] sta = t.getStackTrace();
        ArrayList<Object> list = new ArrayList<Object>();
        if (text != null) {
            list.add(text);
        }
        if (t instanceof I_ErrorInfo) {
            list.add(((I_ErrorInfo)((Object)t)).toInfo());
        } else {
            String className = t.getClass().getSimpleName();
            String message = t.getMessage();
            if (message == null) {
                list.add(className);
            } else {
                list.add(String.valueOf(className) + ": " + t.getMessage());
            }
            if (t instanceof I_ErrorDetails) {
                I_ErrorDetails bf = (I_ErrorDetails)((Object)t);
                for (Object o : bf.getDetails()) {
                    list.add(o);
                }
            }
        }
        this.write(CHANNEL_IN.ERR, OUTPUT_DETAIL.RAW, TRACE.DETAIL, true, true, sta, list.toArray());
        if (t.getCause() != null) {
            this.writeError(t.getCause(), null, true);
        }
    }

    public void writeLog(CHANNEL_IN channel, TRACE trace, boolean error, StackTraceElement[] ste, Object[] oa) {
        if (this.logFile != null) {
            StringBuilder sb = new StringBuilder();
            this.styler.addLogHeader(channel, sb);
            this.styler.style(sb, OUTPUT_STYLE.RAW, channel, OUTPUT_DETAIL.RAW, true, oa);
            if (ste != null) {
                this.styler.addTrace(sb, ste, trace);
            }
            this.directLog(sb.toString());
        }
    }

    private synchronized void directLog(String s) {
        try {
            Lib_TextFile.append(this.logFile, s);
        }
        catch (Err_FileSys e) {
            this.directErr("Log-Write-Error: " + e.getMessage());
        }
    }

    private void writeStd(CHANNEL_IN channel, OUTPUT_DETAIL detail, TRACE trace, boolean error, boolean newLine, StackTraceElement[] ste, Object[] oa, boolean err) {
        if (this.style != OUTPUT_STYLE.RAW) {
            newLine = true;
        }
        if (this.traceDefault != null && this.traceDefault.amount > trace.amount) {
            trace = this.traceDefault;
        }
        boolean addTrace = error ? this.javaErrors : trace != TRACE.NO;
        StringBuilder sb = new StringBuilder();
        if (addTrace) {
            sb.append(this.linebreak);
        }
        if (error) {
            sb.append(new MDateTime().toString());
            sb.append(this.linebreak);
        }
        this.styler.style(sb, this.style, channel, detail, newLine, oa);
        if (addTrace) {
            this.styler.addTrace(sb, ste, trace);
        }
        if (err) {
            this.directErr(sb.toString());
        } else {
            this.directOut(sb.toString());
        }
    }
}

