/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table;

import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.util.Lib_Array;
import de.mn77.base.data.util.Lib_Describe;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Matrix<T>
implements I_Table<T> {
    private final Class<T> clazz;
    private final int length;
    private final T[][] data;
    private final int width;

    public Matrix(Class<T> clazz, int width, int height) {
        this.clazz = clazz;
        this.data = Lib_Array.newArray2(clazz, height, width);
        this.width = width;
        this.length = height;
    }

    @Override
    public void add(Collection<T> row) {
        throw this.iErrorResize();
    }

    @Override
    public void add(int index, T[] element) {
        throw this.iErrorResize();
    }

    @Override
    public boolean add(T[] e) {
        throw this.iErrorResize();
    }

    @Override
    public boolean addAll(Collection<? extends T[]> c) {
        throw this.iErrorResize();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T[]> c) {
        throw this.iErrorResize();
    }

    @Override
    public boolean addRow(T ... row) {
        throw this.iErrorResize();
    }

    @Override
    public void clear() {
        int column = 0;
        while (column < this.width) {
            int row = 1;
            while (row < this.length) {
                this.data[row][column] = null;
                ++row;
            }
            ++column;
        }
    }

    @Override
    public boolean contains(Object o) {
        int column = 0;
        while (column < this.width) {
            int row = 1;
            while (row < this.length) {
                if (this.data[row][column].equals(o)) {
                    return true;
                }
                ++row;
            }
            ++column;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix<T> copy() {
        Matrix<T> result = new Matrix<T>(this.clazz, this.width, this.length);
        int column = 0;
        while (column < this.width) {
            int row = 1;
            while (row < this.length) {
                result.set(column, row, this.get(column, row));
                ++row;
            }
            ++column;
        }
        return result;
    }

    @Override
    public void exchange(int indexA, int indexB) {
        this.exchangeRows(indexA, indexB);
    }

    public void exchangeRows(int indexA, int indexB) {
        Err.ifOutOfBounds(0, this.length, indexA);
        Err.ifOutOfBounds(0, this.length, indexB);
        if (indexA == indexB) {
            MOut.warning("Change of " + indexA + " and " + indexB + " not necessary!");
            return;
        }
        T[] buffer = this.data[indexA];
        this.data[indexA] = this.data[indexB];
        this.data[indexB] = buffer;
    }

    @Override
    public T[] get(int index) {
        return this.getRow(index);
    }

    @Override
    public T get(int column, int row) {
        Err.ifOutOfBounds(0, this.width - 1, column);
        Err.ifOutOfBounds(0, this.length - 1, row);
        return this.data[row][column];
    }

    @Override
    public I_List<T> getColumn(int index) {
        SimpleList<T> result = new SimpleList<T>(this.length);
        int row = 0;
        while (row < result.size()) {
            result.add(this.data[row][index]);
            ++row;
        }
        return result;
    }

    @Override
    public T[] getRow(int index) {
        Object[] result = (Object[])Array.newInstance(Object.class, this.width);
        System.arraycopy(this.data[index], 0, result, index, this.width);
        return result;
    }

    @Override
    public int indexOf(Object o) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public void insertRow(int index, T ... row) {
        throw this.iErrorResize();
    }

    @Override
    public boolean isEmpty() {
        int column = 0;
        while (column < this.width) {
            int row = 1;
            while (row < this.length) {
                if (this.data[row][column] != null) {
                    return false;
                }
                ++row;
            }
            ++column;
        }
        return true;
    }

    @Override
    public Iterator<T[]> iterator() {
        return new Iterator<T[]>(){
            private int nextRow = 0;

            @Override
            public boolean hasNext() {
                return this.nextRow < Matrix.this.length;
            }

            @Override
            public T[] next() {
                return Matrix.this.getRow(this.nextRow++);
            }

            @Override
            public void remove() {
                throw Matrix.this.iErrorResize();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public ListIterator<T[]> listIterator() {
        throw Err.todo(new Object[0]);
    }

    @Override
    public ListIterator<T[]> listIterator(int index) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public T[] remove(int index) {
        throw this.iErrorResize();
    }

    @Override
    public boolean remove(Object o) {
        throw this.iErrorResize();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw this.iErrorResize();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw this.iErrorResize();
    }

    @Override
    public void reverse() {
        Err.todo("Tests needed");
        int mid = this.length / 2;
        int i = 0;
        while (i < mid) {
            this.exchangeRows(i, this.length - 1 - i);
            ++i;
        }
    }

    @Override
    public void set(int column, int row, T object) {
        Err.ifOutOfBounds(0, this.width - 1, column);
        Err.ifOutOfBounds(0, this.length - 1, row);
        this.data[row][column] = object;
    }

    @Override
    public T[] set(int index, T[] element) {
        Err.todo("Tests needed");
        Err.ifNot(element.length, this.width, "Invalid argument length");
        T[] result = this.getRow(index);
        System.arraycopy(element, 0, this.data[index], 0, this.width);
        return result;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public void sort() {
        Sort.table(this, new int[0]);
    }

    @Override
    public void sort(int ... columnOrder) {
        Sort.table(this, columnOrder);
    }

    @Override
    public void sortLike(int[] newIndexes) {
        Err.todo("Tests needed");
        int size = this.data.length;
        Err.ifNot(size, newIndexes.length, "Matrix and order indexes have different length");
        Object[][] ordered = new Object[size][];
        int i = 0;
        while (i < size) {
            ordered[i] = this.data[newIndexes[i]];
            ++i;
        }
        i = 0;
        while (i < size) {
            this.data[i] = ordered[i];
            ++i;
        }
    }

    @Override
    public void sortRandom() {
        Sort.sortableRandom(this);
    }

    @Override
    public List<T[]> subList(int fromIndex, int toIndex) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public Object[] toArray() {
        Object copy = this.copy();
        return ((Matrix)copy).data;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public String toDescribe() {
        return this.toString();
    }

    @Override
    public String toIdent() {
        return Lib_Describe.toIdent(this, this.length);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int row = 0;
        while (row < this.length) {
            int col = 0;
            while (col < this.width) {
                sb.append(this.get(col, row));
                sb.append(col != this.width ? "," : "");
                ++col;
            }
            sb.append('\n');
            ++row;
        }
        return sb.toString();
    }

    @Override
    public int width() {
        return this.width;
    }

    private Err_Runtime iErrorResize() {
        throw Err.impossible("A fixed size matrix can not resized!");
    }
}

