/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table;

import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.util.Lib_Describe;
import de.mn77.base.error.Err;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayTitleTable<T>
implements List<T[]>,
I_Table<T> {
    private final ArrayTable<T> tab;
    private String[] titles = null;

    public ArrayTitleTable(ArrayTable<T> table) {
        this.tab = table;
    }

    public ArrayTitleTable(int width) {
        this.tab = new ArrayTable(width);
    }

    @Override
    public void add(Collection<T> row) {
        this.tab.add(row);
    }

    @Override
    public void add(int index, T[] element) {
        this.tab.add(index, element);
    }

    @Override
    public boolean add(T[] e) {
        return this.tab.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T[]> c) {
        return this.tab.addAll((Collection<T[]>)c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T[]> c) {
        return this.tab.addAll(index, (Collection<T[]>)c);
    }

    @Override
    public boolean addRow(T ... row) {
        return this.tab.addRow(row);
    }

    @Override
    public void clear() {
        this.tab.clear();
        this.titles = null;
    }

    @Override
    public boolean contains(Object o) {
        return this.tab.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.tab.containsAll(c);
    }

    @Override
    public ArrayTitleTable<T> copy() {
        ArrayTitleTable<T> result = new ArrayTitleTable<T>(this.tab.copy());
        result.setTitles(this.titles);
        return result;
    }

    @Override
    public void exchange(int indexA, int indexB) {
        this.tab.exchange(indexA, indexB);
    }

    @Override
    public T[] get(int index) {
        return this.tab.get(index);
    }

    @Override
    public T get(int col, int row) {
        return this.tab.get(col, row);
    }

    @Override
    public I_List<T> getColumn(int index) {
        return this.tab.getColumn(index);
    }

    @Override
    public T[] getRow(int index) {
        return this.getRow(index);
    }

    public String[] getTitles() {
        return this.titles;
    }

    @Override
    public int indexOf(Object o) {
        return this.tab.indexOf(o);
    }

    @Override
    public void insertRow(int index, T ... row) {
        this.tab.insertRow(index, row);
    }

    @Override
    public boolean isEmpty() {
        return this.tab.isEmpty();
    }

    @Override
    public Iterator<T[]> iterator() {
        return this.tab.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.tab.lastIndexOf(o);
    }

    @Override
    public ListIterator<T[]> listIterator() {
        return this.tab.listIterator();
    }

    @Override
    public ListIterator<T[]> listIterator(int index) {
        return this.tab.listIterator(index);
    }

    @Override
    public T[] remove(int index) {
        return this.tab.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.tab.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.tab.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.tab.retainAll(c);
    }

    @Override
    public void reverse() {
        this.tab.reverse();
    }

    @Override
    public void set(int col, int row, T o) {
        this.tab.set(col, row, o);
    }

    @Override
    public T[] set(int index, T[] element) {
        return this.tab.set(index, element);
    }

    public void setTitles(String ... titles) {
        Err.ifNot(titles.length, this.tab.width());
        this.titles = titles;
    }

    @Override
    public int size() {
        return this.tab.size();
    }

    @Override
    public void sort() {
        this.tab.sort();
    }

    @Override
    public void sort(int ... columnOrder) {
        this.tab.sort(columnOrder);
    }

    @Override
    public void sortLike(int[] newOrder) {
        this.tab.sortLike(newOrder);
    }

    @Override
    public void sortRandom() {
        this.tab.sortRandom();
    }

    @Override
    public List<T[]> subList(int fromIndex, int toIndex) {
        return this.tab.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.tab.toArray();
    }

    @Override
    public <TA> TA[] toArray(TA[] a) {
        return this.tab.toArray(a);
    }

    @Override
    public String toDescribe() {
        return this.toString();
    }

    @Override
    public String toIdent() {
        return Lib_Describe.toIdent(this, this.tab.size());
    }

    @Override
    public String toString() {
        return this.tab.toString(this.titles);
    }

    @Override
    public int width() {
        return this.tab.width();
    }
}

