/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.SimpleSet;
import de.mn77.base.error.Err;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleMap<TA, TB>
implements Map<TA, TB>,
Iterable<Group2<TA, TB>> {
    protected SimpleList<TB> values = new SimpleList();
    private final SimpleSet<TA> keys = new SimpleSet();

    public void add(TA key, TB object) {
        if (this.keys.contains(key)) {
            Err.invalid("Key is already known: " + key);
        }
        this.keys.add(key);
        this.values.add(object);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    public SimpleMap<TA, TB> copy() {
        SimpleMap result = new SimpleMap();
        for (Group2<TA, TB> g : this) {
            result.add(g.o1, g.o2);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<TA, TB>> entrySet() {
        SimpleSet<Map.Entry<TA, TB>> result = new SimpleSet<Map.Entry<TA, TB>>();
        int i = 0;
        while (i < this.keys.size()) {
            result.add(new Entry(i));
            ++i;
        }
        return result;
    }

    public Group2<TA, TB> get(int row) {
        return new Group2<TA, TB>(this.keys.get(row), this.values.get(row));
    }

    @Override
    public TB get(Object key) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            Err.invalid("Unknown key: " + key);
        }
        return this.values.get(index);
    }

    public TB get(TA key, TB ifMissing) {
        Integer index = this.keys.searchFirst(key);
        return index == null ? ifMissing : this.values.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.keys.size() == 0;
    }

    @Override
    public Iterator<Group2<TA, TB>> iterator() {
        return new Iterator<Group2<TA, TB>>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < SimpleMap.this.size();
            }

            @Override
            public Group2<TA, TB> next() {
                return new Group2(SimpleMap.this.keys.get(this.next), SimpleMap.this.values.get(this.next++));
            }

            @Override
            public void remove() {
                Err.forbidden(new Object[0]);
            }
        };
    }

    @Override
    public Set<TA> keySet() {
        return this.keys.copy();
    }

    @Override
    public TB put(TA key, TB value) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            this.keys.add(key);
            this.values.add(value);
            return null;
        }
        return this.values.set(0, value);
    }

    @Override
    public void putAll(Map<? extends TA, ? extends TB> m) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public TB remove(Object key) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            Err.invalid("Unknown key: " + key);
        }
        this.keys.remove(index);
        TB result = this.values.get(index);
        this.values.remove(index);
        return result;
    }

    @Override
    public TB replace(TA key, TB newObject) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int row = 0;
        while (row < this.size()) {
            sb.append(String.valueOf(ConvertObject.toStringIdent(this.keys.get(row))) + "," + ConvertObject.toStringIdent(this.values.get(row)) + "\n");
            ++row;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public Collection<TB> values() {
        return this.values.copy();
    }

    private class Entry
    implements Map.Entry<TA, TB> {
        private final int index;

        private Entry(int index) {
            this.index = index;
        }

        @Override
        public TA getKey() {
            return SimpleMap.this.keys.get(this.index);
        }

        @Override
        public TB getValue() {
            return SimpleMap.this.values.get(this.index);
        }

        @Override
        public TB setValue(TB value) {
            throw Err.invalid(value);
        }
    }
}

