/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.convert;

import de.mn77.base.error.Err;

public class ConvertNumber {
    private static final String chars_hex = "0123456789ABCDEF";
    private static final char[] chars_hex_array = "0123456789ABCDEF".toCharArray();

    public static byte[] fromHex(String s) {
        if (s.length() % 2 != 0) {
            Err.invalid(s);
        }
        byte[] result = new byte[s.length() / 2];
        Integer buffer = null;
        byte[] ba = s.toUpperCase().getBytes();
        int pos = 0;
        byte[] byArray = ba;
        int n = ba.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (buffer == null) {
                buffer = chars_hex.indexOf(b) * 16;
            } else {
                result[pos] = (byte)(buffer + chars_hex.indexOf(b));
                buffer = null;
                ++pos;
            }
            ++n2;
        }
        return result;
    }

    public static String toHex(byte[] ba) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = ba;
        int n = ba.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int i = b & 0xFF;
            sb.append(chars_hex_array[i / 16]);
            sb.append(chars_hex_array[i % 16]);
            ++n2;
        }
        return sb.toString();
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    public static String toString(Integer integer) {
        if (integer == null) {
            return null;
        }
        return "" + integer;
    }
}

