/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.convert;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;

public class ConvertArray {
    public static int[] toIntArray(Integer[] ia) {
        Err.ifNull((Object)ia);
        int[] result = new int[ia.length];
        int i = 0;
        while (i < ia.length) {
            result[i] = ia[i];
            ++i;
        }
        return result;
    }

    public static <TA> SimpleList<TA> toSimpleList(TA[] arr) {
        SimpleList<TA> result = new SimpleList<TA>(arr.length);
        result.addMore(arr);
        return result;
    }

    public static String toString(String delimiter, Object ... arr) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(arr[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(String delimiter, String ... arr) {
        return String.join((CharSequence)delimiter, arr);
    }

    public static String[] toStringArray(int ... ia) {
        Err.ifNull((Object)ia);
        String[] result = new String[ia.length];
        int i = 0;
        while (i < ia.length) {
            result[i] = "" + ia[i];
            ++i;
        }
        return result;
    }

    public static <TA> String[] toStringArray(TA[] oa) {
        Err.ifNull(oa);
        if (oa instanceof String[]) {
            return (String[])oa;
        }
        String[] result = new String[oa.length];
        int i = 0;
        while (i < oa.length) {
            result[i] = ConvertObject.toText(oa[i]);
            ++i;
        }
        return result;
    }
}

