/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.constant.ALIGN;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.tablestyle.TableStyler;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Java;

public class Lib_TableStyle {
    public static String compute(CallRuntime cr, ArrayTable<I_Object> tab, String[] defs) {
        Err.ifNull(tab, defs);
        Err.ifNot(defs.length, 3);
        CONV conv = CONV.OBJECT;
        if (defs[0] != null) {
            if (defs[0].indexOf(73) >= 0) {
                conv = CONV.IDENT;
                defs[0] = FilterString.removeChar('I', defs[0]);
            }
            if (defs[0].indexOf(68) >= 0) {
                conv = CONV.DESCRIBE;
                defs[0] = FilterString.removeChar('D', defs[0]);
            }
        }
        ArrayTable objectTable = new ArrayTable(tab.width(), tab.size());
        int y = 0;
        while (y < tab.size()) {
            Object[] row = new Object[tab.width()];
            int x = 0;
            while (x < tab.width()) {
                row[x] = conv == CONV.OBJECT ? Lib_Java.jmoToJava(cr, tab.get(x, y), Object.class, false) : (conv == CONV.IDENT ? tab.get(x, y).toString(cr, STYPE.IDENT) : tab.get(x, y).toString(cr, STYPE.DESCRIBE));
                ++x;
            }
            objectTable.add(row);
            ++y;
        }
        TableStyler styler = new TableStyler();
        if (defs[0] != null) {
            Lib_TableStyle.iSetTableStyles(cr, styler, defs[0]);
        }
        if (defs[1] != null) {
            Lib_TableStyle.iSetColumnStyles(cr, styler, defs[1]);
        }
        if (defs[2] != null) {
            Lib_TableStyle.iSetRowStyles(cr, styler, defs[2]);
        }
        return styler.compute(objectTable);
    }

    private static void iSetColumnStyles(CallRuntime cr, TableStyler styler, String def) {
        Group2<String, String> split = Lib_TableStyle.iSplitColumnStyles(cr, def);
        int i = 0;
        char[] cArray = ((String)split.o1).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '<': 
                case 'L': {
                    styler.alignColumn(i, ALIGN.LEFT);
                    break;
                }
                case 'C': 
                case '^': {
                    styler.alignColumn(i, ALIGN.CENTER);
                    break;
                }
                case '>': 
                case 'R': {
                    styler.alignColumn(i, ALIGN.RIGHT);
                    break;
                }
                case '_': {
                    break;
                }
                default: {
                    Err.impossible(Character.valueOf(c));
                }
            }
            ++i;
            ++n2;
        }
        styler.colLineStyles((String)split.o2);
    }

    private static void iSetRowStyles(CallRuntime cr, TableStyler styler, String def) {
        char[] cArray = def.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '*': 
                case '+': 
                case '-': {
                    break;
                }
                default: {
                    throw Lib_TableStyle.iThrowInvalidChar(cr, "row", c);
                }
            }
            ++n2;
        }
        styler.rowLineStyles(def);
    }

    private static void iSetTableStyles(CallRuntime cr, TableStyler styler, String def) {
        char[] cArray = def.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'b': {
                    styler.setBorder(true);
                    break;
                }
                case 'u': {
                    styler.setUnicode(true);
                    break;
                }
                case '<': 
                case 'L': {
                    styler.alignDefault(ALIGN.LEFT);
                    break;
                }
                case 'C': 
                case '^': {
                    styler.alignDefault(ALIGN.CENTER);
                    break;
                }
                case '>': 
                case 'R': {
                    styler.alignDefault(ALIGN.RIGHT);
                    break;
                }
                case '!': 
                case '1': 
                case '2': 
                case '|': {
                    styler.colLineStyleDefault(c);
                    break;
                }
                case '+': 
                case '-': {
                    styler.rowLineStyleDefault(c);
                    break;
                }
                default: {
                    throw Lib_TableStyle.iThrowInvalidChar(cr, "table", c);
                }
            }
            ++n2;
        }
    }

    private static Group2<String, String> iSplitColumnStyles(CallRuntime cr, String def) {
        StringBuilder align = new StringBuilder(def.length());
        StringBuilder lines = new StringBuilder(def.length());
        boolean onLine = false;
        char[] cArray = def.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '<': 
                case '>': 
                case 'C': 
                case 'L': 
                case 'R': 
                case '^': 
                case '_': {
                    if (onLine) {
                        lines.append('.');
                    }
                    align.append(c);
                    onLine = true;
                    break;
                }
                case '!': 
                case '.': 
                case '1': 
                case '2': 
                case '|': {
                    if (!onLine) {
                        align.append('_');
                    }
                    lines.append(c);
                    onLine = false;
                    break;
                }
                default: {
                    throw Lib_TableStyle.iThrowInvalidChar(cr, "column", c);
                }
            }
            ++n2;
        }
        return new Group2<String, String>(align.toString(), lines.toString());
    }

    private static RuntimeError iThrowInvalidChar(CallRuntime cr, String part, char c) {
        throw new RuntimeError(cr, "Invalid char for " + part + " definition", "Invalid: '" + c + "'");
    }

    private static enum CONV {
        OBJECT,
        IDENT,
        DESCRIBE;

    }
}

