/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.HtmlChars;
import de.mn77.base.data.constant.ALIGN;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import java.util.Iterator;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;

public class Lib_StrFormat {
    private static final String ERR_INVALID_CELL = "Illegal cell definition in format string";

    public static Str fill(CallRuntime cr, String format, I_Object obj) {
        int formIndex = 0;
        StringBuilder sb = new StringBuilder();
        while (formIndex < format.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(format, formIndex);
            formIndex += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, obj));
        }
        return new Str(sb.toString());
    }

    public static Str fill(CallRuntime cr, String format, Iterator<I_Object> objs) {
        int formIndex = 0;
        StringBuilder sb = new StringBuilder();
        while (formIndex < format.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(format, formIndex);
            formIndex += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue() || !objs.hasNext()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, objs.next()));
        }
        return new Str(sb.toString());
    }

    public static String format(CallRuntime cr, String form, I_Object obj) {
        int fieldLen;
        int len = form.length();
        String value = Lib_Convert.getStringValue(cr, obj);
        if (len == 2) {
            return value;
        }
        Boolean cutOverflow = null;
        ALIGN align = null;
        Character type = null;
        StringBuilder size = new StringBuilder();
        SIZE_STATE sizeState = SIZE_STATE.UNDEFINED;
        int dpi = form.indexOf(58);
        String cell = form.substring(1, dpi >= 0 ? dpi : form.length() - 1);
        String spec = dpi >= 0 ? form.substring(dpi + 1, form.length() - 1) : "";
        char[] cArray = cell.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= '0' && c <= '9') {
                if (sizeState == SIZE_STATE.FINISHED) {
                    cr.warning(ERR_INVALID_CELL, "Cell size already set! Got: '" + cell + "'");
                } else {
                    sizeState = SIZE_STATE.ADD;
                    size.append(c);
                }
            } else {
                if (sizeState == SIZE_STATE.ADD) {
                    sizeState = SIZE_STATE.FINISHED;
                }
                switch (c) {
                    case '!': {
                        if (cutOverflow != null) {
                            cr.warning(ERR_INVALID_CELL, "Overflow handling already set. But got: '" + c + "'");
                            break;
                        }
                        cutOverflow = true;
                        break;
                    }
                    case '?': {
                        if (cutOverflow != null) {
                            cr.warning(ERR_INVALID_CELL, "Overflow handling already set. But got: '" + c + "'");
                            break;
                        }
                        cutOverflow = false;
                        break;
                    }
                    case '<': 
                    case 'L': {
                        if (align != null) {
                            cr.warning(ERR_INVALID_CELL, "Align already set. But got: '" + c + "'");
                            break;
                        }
                        align = ALIGN.LEFT;
                        break;
                    }
                    case '>': 
                    case 'R': {
                        if (align != null) {
                            cr.warning(ERR_INVALID_CELL, "Align already set. But got: '" + c + "'");
                            break;
                        }
                        align = ALIGN.RIGHT;
                        break;
                    }
                    case 'C': 
                    case '^': {
                        if (align != null) {
                            cr.warning(ERR_INVALID_CELL, "Align already set. But got: '" + c + "'");
                            break;
                        }
                        align = ALIGN.CENTER;
                        break;
                    }
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'i': 
                    case 's': 
                    case 't': {
                        if (type != null) {
                            cr.warning(ERR_INVALID_CELL, "Cell type already set. But got: '" + c + "'");
                            break;
                        }
                        type = Character.valueOf(c);
                        break;
                    }
                    default: {
                        cr.warning(ERR_INVALID_CELL, "Invalid char, maybe ':' is missing? Got: '" + c + "'");
                    }
                }
            }
            ++n2;
        }
        int n3 = fieldLen = size.length() == 0 ? 0 : Integer.parseInt(size.toString());
        if (cutOverflow == null) {
            cutOverflow = false;
        }
        if (type == null) {
            type = Character.valueOf((char)(obj instanceof Bool ? 98 : (obj instanceof Char ? 99 : (obj instanceof JMo_Dec ? 100 : (obj instanceof Int ? 105 : (obj instanceof JMo_Byte ? 105 : (obj instanceof JMo_Double ? 100 : (obj instanceof JMo_Float ? 100 : (obj instanceof JMo_Long ? 105 : (obj instanceof JMo_Short ? 105 : (obj instanceof JMo_BigInt ? 105 : (obj instanceof JMo_BigDec ? 100 : 115))))))))))));
        }
        switch (type.charValue()) {
            case 's': {
                if (align == null) {
                    align = ALIGN.LEFT;
                }
                value = Lib_StrFormat.iSpecString(cr, obj, value, spec, form);
                break;
            }
            case 'c': {
                if (align == null) {
                    align = ALIGN.LEFT;
                }
                value = Lib_StrFormat.iSpecChar(cr, obj, spec, form);
                break;
            }
            case 'i': {
                if (align == null) {
                    align = ALIGN.RIGHT;
                }
                value = Lib_StrFormat.iSpecInt(cr, obj, spec, form);
                break;
            }
            case 'd': {
                if (align == null) {
                    align = ALIGN.RIGHT;
                }
                value = Lib_StrFormat.iSpecDec(cr, obj, spec);
                break;
            }
            case 'b': {
                if (align == null) {
                    align = ALIGN.LEFT;
                }
                value = Lib_StrFormat.iSpecBool(cr, obj, spec);
                break;
            }
            case 't': {
                if (align == null) {
                    align = ALIGN.LEFT;
                }
                value = Lib_StrFormat.iSpecType(cr, obj, spec);
                break;
            }
            default: {
                throw Err.todo(form, value, type);
            }
        }
        return FormString.width(fieldLen, ' ', value, align, cutOverflow);
    }

    public static final Group2<Boolean, String> getNext(String s, int offset) {
        boolean formatOpen = false;
        int pos = offset;
        while (pos < s.length()) {
            char c = s.charAt(pos);
            if (c == '\\') {
                ++pos;
            } else {
                if (c == '{') {
                    if (pos == offset) {
                        formatOpen = true;
                    } else {
                        return new Group2<Boolean, String>(false, s.substring(offset, pos));
                    }
                }
                if (c == '}' && formatOpen) {
                    return new Group2<Boolean, String>(true, s.substring(offset, pos + 1));
                }
            }
            ++pos;
        }
        return new Group2<Boolean, String>(formatOpen, s.substring(offset));
    }

    private static String iSpecBool(CallRuntime cr, I_Object o, String sSpec) {
        boolean b = Lib_Convert.getBoolValue(cr, o);
        if (sSpec.length() > 1) {
            Lib_StrFormat.iSpecThrow(cr, "Bool", sSpec);
            sSpec = sSpec.substring(0, 1);
        }
        if (sSpec.length() == 1) {
            switch (sSpec.charAt(0)) {
                case 'u': {
                    return b ? "TRUE" : "FALSE";
                }
                case 'l': {
                    return b ? "true" : "false";
                }
                case 'C': 
                case 'c': {
                    return b ? "True" : "False";
                }
            }
            Lib_StrFormat.iSpecFormatThrow(cr, "Bool", sSpec);
        }
        return b ? "true" : "false";
    }

    private static String iSpecChar(CallRuntime cr, I_Object o, String sSpec, String form) {
        String os = "" + Lib_Convert.getCharValue(cr, o, true);
        if (sSpec.length() == 0) {
            return os;
        }
        if (sSpec.length() > 1) {
            Lib_StrFormat.iSpecFormatThrow(cr, "Character", sSpec);
            sSpec = sSpec.substring(0, 1);
        }
        switch (sSpec.charAt(0)) {
            case 'u': {
                return os.toUpperCase();
            }
            case 'l': {
                return os.toLowerCase();
            }
        }
        Lib_StrFormat.iSpecCharThrow(cr, "Character", sSpec.charAt(0), sSpec, form);
        return os;
    }

    private static void iSpecCharThrow(CallRuntime cr, String type, char c, String sSpec, String form) {
        String detail = "Invalid special format char '" + sSpec.charAt(0) + "' in '" + form + "'";
        Lib_StrFormat.iSpecThrow(cr, type, detail);
    }

    private static String iSpecDec(CallRuntime cr, I_Object o, String sSpec) {
        double d = Lib_Convert.getDoubleValue(cr, o);
        JMo_Double jd = (JMo_Double)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.DOUBLE);
        String os = jd.toString();
        if (sSpec.length() == 0) {
            return os;
        }
        String sign = null;
        StringBuilder sbDigits = new StringBuilder();
        boolean digitBreak = false;
        char[] cArray = sSpec.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '+') {
                if (sign != null) {
                    Lib_StrFormat.iSpecFormatThrow(cr, "Decimal", sSpec);
                }
                String string = sign = d < 0.0 ? "" : "+";
                if (sbDigits.length() > 0) {
                    digitBreak = true;
                }
            } else if (c >= '0' && c <= '9') {
                if (digitBreak) {
                    Lib_StrFormat.iSpecFormatThrow(cr, "Decimal", sSpec);
                }
                sbDigits.append(c);
            } else {
                Lib_StrFormat.iSpecFormatThrow(cr, "Decimal", sSpec);
            }
            ++n2;
        }
        if (sbDigits.length() > 0) {
            int digits = Integer.parseInt(sbDigits.toString());
            os = digits == 0 ? "" + Math.round(d) : FormNumber.round(d, digits);
        }
        return sign != null ? String.valueOf(sign) + os : os;
    }

    private static void iSpecFormatThrow(CallRuntime cr, String type, String sSpec) {
        String detail = "Invalid special format: '" + sSpec + "'";
        Lib_StrFormat.iSpecThrow(cr, type, detail);
    }

    private static String iSpecInt(CallRuntime cr, I_Object o, String sSpec, String form) {
        String os = "" + Lib_Convert.getIntValue(cr, o, false);
        if (sSpec.length() == 0) {
            return os;
        }
        if (sSpec.length() > 1) {
            Lib_StrFormat.iSpecFormatThrow(cr, "Integer", sSpec);
            sSpec = sSpec.substring(0, 1);
        }
        if (sSpec.charAt(0) == '+') {
            return os.charAt(0) == '-' ? os : String.valueOf('+') + os;
        }
        Lib_StrFormat.iSpecCharThrow(cr, "Integer", sSpec.charAt(0), sSpec, form);
        return os;
    }

    private static String iSpecString(CallRuntime cr, I_Object o, String os, String sSpec, String form) {
        String result;
        if (sSpec.length() == 0) {
            return os;
        }
        Character conversionEscape = null;
        Character conversionHtml = null;
        Character caseChange = null;
        Character quote = null;
        Character conversionString = null;
        boolean trim = false;
        char[] cArray = sSpec.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case 'D': 
                case 'I': 
                case 'S': {
                    if (conversionString != null) {
                        Lib_StrFormat.iSpecThrow(cr, "String", "Only one object to string conversion is allowed [s,i,d] but got: " + sSpec);
                        break;
                    }
                    conversionString = Character.valueOf(c);
                    break;
                }
                case 't': {
                    if (trim) {
                        Lib_StrFormat.iSpecThrow(cr, "String", "Trim was already set: " + sSpec);
                        break;
                    }
                    trim = true;
                    break;
                }
                case 'E': 
                case 'e': 
                case 'r': {
                    if (conversionEscape != null) {
                        Lib_StrFormat.iSpecThrow(cr, "String", "Only one escape conversion is allowed [e,E,r] but got: " + sSpec);
                        break;
                    }
                    conversionEscape = Character.valueOf(c);
                    break;
                }
                case 'H': 
                case 'R': 
                case 'h': {
                    if (conversionHtml != null) {
                        Lib_StrFormat.iSpecThrow(cr, "String", "Only one html conversion is allowed [h,H,R] but got: " + sSpec);
                        break;
                    }
                    conversionHtml = Character.valueOf(c);
                    break;
                }
                case 'C': 
                case 'c': 
                case 'l': 
                case 'u': {
                    if (caseChange != null) {
                        Lib_StrFormat.iSpecThrow(cr, "String", "Only one case type is allowed [l,u,c,C] but got: " + sSpec);
                        break;
                    }
                    caseChange = Character.valueOf(c);
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': {
                    if (quote != null) {
                        Lib_StrFormat.iSpecThrow(cr, "String", "Only one quote type is allowed [1,2,3,4] but got: " + sSpec);
                        break;
                    }
                    quote = Character.valueOf(c);
                    break;
                }
                default: {
                    Lib_StrFormat.iSpecCharThrow(cr, "String", c, sSpec, form);
                }
            }
            ++n2;
        }
        String string = conversionString == null || conversionString.charValue() == 'S' ? os : (result = conversionString.charValue() == 'I' ? o.toString(cr, STYPE.IDENT) : o.toString(cr, STYPE.DESCRIBE));
        if (trim) {
            result = result.trim();
        }
        STR_ESCAPE doEscape = STR_ESCAPE.NONE;
        STR_ESCAPE escaped = STR_ESCAPE.NONE;
        if (conversionEscape != null) {
            switch (conversionEscape.charValue()) {
                case 'e': {
                    doEscape = STR_ESCAPE.NUL;
                    break;
                }
                case 'E': {
                    doEscape = STR_ESCAPE.ALL;
                    break;
                }
                case 'r': {
                    result = FormString.unescapeSpecialChars(result);
                }
            }
        }
        if (conversionHtml != null) {
            switch (conversionHtml.charValue()) {
                case 'h': {
                    result = HtmlChars.htmlSpecialChars(result);
                    break;
                }
                case 'H': {
                    result = HtmlChars.htmlEntities(result);
                    break;
                }
                case 'R': {
                    result = HtmlChars.htmlEntitiesDecode(result);
                }
            }
        }
        if (caseChange != null) {
            switch (caseChange.charValue()) {
                case 'u': {
                    result = result.toUpperCase();
                    break;
                }
                case 'l': {
                    result = result.toLowerCase();
                    break;
                }
                case 'c': {
                    result = Lib_String.capitalize(result, true);
                    break;
                }
                case 'C': {
                    result = Lib_String.capitalize(result, false);
                    break;
                }
                default: {
                    Err.impossible(caseChange);
                }
            }
        }
        if (quote != null) {
            boolean quoteEscape = doEscape == STR_ESCAPE.ALL;
            switch (quote.charValue()) {
                case '1': {
                    result = FormString.quote(result, '\'', '\\', quoteEscape);
                    break;
                }
                case '2': {
                    result = FormString.quote(result, '\"', '\\', quoteEscape);
                    break;
                }
                case '3': {
                    result = FormString.quote(result, '\'', '\'', quoteEscape);
                    break;
                }
                case '4': {
                    result = FormString.quote(result, '\"', '\"', quoteEscape);
                    break;
                }
                default: {
                    Err.impossible(caseChange);
                }
            }
            STR_ESCAPE sTR_ESCAPE = escaped = quoteEscape ? STR_ESCAPE.ALL : STR_ESCAPE.NUL;
        }
        if (doEscape != STR_ESCAPE.NONE && escaped == STR_ESCAPE.NONE) {
            switch (doEscape) {
                case NUL: {
                    result = FormString.escapeSlashes(result);
                    break;
                }
                case ALL: {
                    result = FormString.escapeSpecialChars(result, false, false);
                }
            }
        }
        return result;
    }

    private static void iSpecThrow(CallRuntime cr, String type, String detail) {
        cr.warning("Illegal styles for '" + type + "' in format string!", detail);
    }

    private static String iSpecType(CallRuntime cr, I_Object o, String sSpec) {
        if (sSpec.length() != 0) {
            Lib_StrFormat.iSpecFormatThrow(cr, "Type", sSpec);
        }
        I_Object o2 = Lib_Convert.getValue(cr, o);
        return o2.getType(cr).toString();
    }

    private static enum SIZE_STATE {
        UNDEFINED,
        ADD,
        FINISHED;

    }

    private static enum STR_ESCAPE {
        NONE,
        NUL,
        ALL;

    }
}

