/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.bigcalc.Lib_BigCalc;
import de.mn77.base.data.util.Lib_BigMath;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_ConvertExact;

public class Lib_AtomicMath {
    public static A_Number calcBigDec(CallRuntime cr, NOP1 op, BigDecimal value, BigDecimal arg) {
        switch (op) {
            case ADD: {
                return new JMo_BigDec(arg.add(value));
            }
            case SUB: {
                return new JMo_BigDec(value.subtract(arg));
            }
            case MUL: {
                return new JMo_BigDec(value.multiply(arg));
            }
            case DIV: {
                if (arg.signum() == 0) {
                    Lib_AtomicMath.iDivisionByZero(cr, value, arg);
                    return new JMo_BigDec(BigDecimal.ZERO);
                }
                return new JMo_BigDec(value.divide(arg, JMo_BigDec.CONTEXT));
            }
            case MOD: {
                return new JMo_BigDec(Lib_BigMath.modulo(value, arg));
            }
            case LOG: {
                return new JMo_BigDec(Lib_BigMath.log(arg, value, JMo_BigDec.CONTEXT));
            }
            case POW: {
                return new JMo_BigDec(Lib_BigCalc.pow(value, arg, JMo_BigDec.CONTEXT));
            }
            case ROOT: {
                return new JMo_BigDec(Lib_BigCalc.exp(Lib_BigCalc.log(value, JMo_BigDec.CONTEXT).divide(arg, JMo_BigDec.CONTEXT), JMo_BigDec.CONTEXT));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number calcBigInt(CallRuntime cr, NOP1 op, BigInteger value, BigInteger arg) {
        switch (op) {
            case ADD: {
                return new JMo_BigInt(arg.add(value));
            }
            case SUB: {
                return new JMo_BigInt(value.subtract(arg));
            }
            case MUL: {
                return new JMo_BigInt(value.multiply(arg));
            }
            case DIV: {
                if (arg.signum() == 0) {
                    Lib_AtomicMath.iDivisionByZero(cr, value, arg);
                    return new JMo_BigDec(BigDecimal.ZERO);
                }
                return new JMo_BigDec(new BigDecimal(value).divide(new BigDecimal(arg), JMo_BigDec.CONTEXT));
            }
            case MOD: {
                return new JMo_BigInt(value.mod(arg));
            }
            case LOG: {
                return new JMo_BigDec(Lib_BigMath.log(new BigDecimal(arg), new BigDecimal(value), JMo_BigDec.CONTEXT));
            }
            case POW: {
                return new JMo_BigInt(value.pow(arg.intValueExact()));
            }
            case ROOT: {
                return new JMo_BigDec(Lib_BigCalc.exp(Lib_BigCalc.log(new BigDecimal(value), JMo_BigDec.CONTEXT).divide(new BigDecimal(arg), JMo_BigDec.CONTEXT), JMo_BigDec.CONTEXT));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number calcDec(CallRuntime cr, NOP1 op, Dec value, Dec arg) {
        switch (op) {
            case ADD: {
                return new JMo_Dec(value.add(arg));
            }
            case SUB: {
                return new JMo_Dec(value.sub(arg));
            }
            case MUL: {
                return new JMo_Dec(value.mul(arg));
            }
            case DIV: {
                if (arg.is0()) {
                    Lib_AtomicMath.iDivisionByZero(cr, value, arg);
                    return new JMo_Dec(Dec.ZERO);
                }
                return new JMo_Dec(value.div(arg));
            }
            case MOD: {
                return new JMo_Dec(value.mod(arg));
            }
            case LOG: {
                return new JMo_Dec(value.log(arg));
            }
            case POW: {
                return new JMo_Dec(value.pow(arg));
            }
            case ROOT: {
                return new JMo_Dec(value.root(arg));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number calcDouble(CallRuntime cr, NOP1 op, double value, double arg) {
        switch (op) {
            case ADD: {
                return new JMo_Double(value + arg);
            }
            case SUB: {
                return new JMo_Double(value - arg);
            }
            case MUL: {
                return new JMo_Double(value * arg);
            }
            case DIV: {
                if (arg == 0.0) {
                    Lib_AtomicMath.iDivisionByZero(cr, value, arg);
                    return new JMo_Double(0.0);
                }
                return new JMo_Double(value / arg);
            }
            case MOD: {
                return new JMo_Double(value % arg);
            }
            case LOG: {
                return new JMo_Double(Math.log(value) / Math.log(arg));
            }
            case POW: {
                return new JMo_Double(Math.pow(value, arg));
            }
            case ROOT: {
                return new JMo_Double(Math.exp(Math.log(value) / arg));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number calcInt(CallRuntime cr, NOP1 op, int value, int arg) {
        switch (op) {
            case ADD: {
                return new Int(value + arg);
            }
            case SUB: {
                return new Int(value - arg);
            }
            case MUL: {
                return new Int(value * arg);
            }
            case DIV: {
                if (arg == 0) {
                    Lib_AtomicMath.iDivisionByZero(cr, value, arg);
                    return new JMo_Dec(Dec.ZERO);
                }
                return JMo_Dec.valueOf(cr, (double)value / (double)arg);
            }
            case MOD: {
                return new Int(value % arg);
            }
            case LOG: {
                double logResult = Math.log(value) / Math.log(arg);
                return JMo_Dec.valueOf(cr, logResult);
            }
            case POW: {
                double res = Math.pow(value, arg);
                int i = Lib_ConvertExact.doubleToInt(cr, res);
                return new Int(i);
            }
            case ROOT: {
                return JMo_Dec.valueOf(cr, Math.exp(Math.log(value) / (double)arg));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number calcLong(CallRuntime cr, NOP1 op, long value, long arg) {
        switch (op) {
            case ADD: {
                return new JMo_Long(value + arg);
            }
            case SUB: {
                return new JMo_Long(value - arg);
            }
            case MUL: {
                return new JMo_Long(value * arg);
            }
            case DIV: {
                if (arg == 0L) {
                    Lib_AtomicMath.iDivisionByZero(cr, value, arg);
                    return new JMo_Double(0.0);
                }
                return new JMo_Double((double)value / (double)arg);
            }
            case MOD: {
                return new JMo_Long(value % arg);
            }
            case LOG: {
                return new JMo_Double(Math.log(value) / Math.log(arg));
            }
            case POW: {
                double res = Math.pow(value, arg);
                long l = Lib_ConvertExact.doubleToLong(cr, res);
                return new JMo_Long(l);
            }
            case ROOT: {
                return new JMo_Double(Math.exp(Math.log(value) / (double)arg));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    private static void iDivisionByZero(CallRuntime cr, Object value, Object arg) {
        cr.warning("Division by zero", value + " / " + arg);
    }
}

