/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Prefix;
import org.jaymo_lang.util.Lib_Type;

public class ParseObj_VarConstType
implements I_ParseObject {
    private static final String matching = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789? \t";
    public static final String NOT = "=+-*/!<>";

    @Override
    public boolean hits(char c0, Block current, String s) {
        if (c0 != '_' && (c0 < 'A' || c0 > 'Z')) {
            return false;
        }
        STATE state = STATE.TYPE;
        int len = s.length();
        boolean openSub = false;
        int i = 1;
        while (i < len) {
            char c = s.charAt(i);
            switch (state) {
                case TYPE: {
                    if (c == '{') {
                        openSub = true;
                        break;
                    }
                    if (c == '}') {
                        openSub = false;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || openSub && (c == '.' || c == '$')) break;
                    if (c == ' ' || c == '\t' || c == '?') {
                        state = STATE.SPACE1;
                        break;
                    }
                    return false;
                }
                case SPACE1: {
                    if (c == ' ' || c == '\t') break;
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        state = STATE.VARCONST;
                        break;
                    }
                    return false;
                }
                case VARCONST: {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') break;
                    if (c == '?' || c == ' ' || c == '\t') {
                        state = STATE.SPACE2;
                        break;
                    }
                    if (c == '=') {
                        state = STATE.LET;
                        break;
                    }
                    if (c == '~') break;
                    return false;
                }
                case SPACE2: {
                    if (c == ' ' || c == '\t') break;
                    if (c == '=') {
                        state = STATE.LET;
                        break;
                    }
                    if (c == '~') break;
                    return false;
                }
                case LET: {
                    return len > i && NOT.indexOf(s.charAt(i)) == -1;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        char vcn0;
        String type;
        boolean typeNilable;
        Err.ifNull((Object)current);
        int is = s.indexOf(32);
        if (is == -1) {
            is = s.indexOf(9);
        }
        boolean bl = typeNilable = (type = s.substring(0, is)).charAt(type.length() - 1) == '?';
        if (typeNilable) {
            type = type.substring(0, type.length() - 1);
        }
        Lib_Type.checkValidity(type, parser);
        if (type.charAt(0) == '_') {
            type = Lib_Prefix.addPrefix(type, parser);
        }
        String vcName = "";
        int pointer = is;
        char c0 = s.charAt(pointer);
        while (matching.indexOf(c0) >= 0) {
            ++pointer;
            if (c0 != ' ' && c0 != '\t') {
                vcName = String.valueOf(vcName) + c0;
            }
            if (pointer >= s.length()) break;
            c0 = s.charAt(pointer);
        }
        String rem = s.substring(pointer);
        if (typeNilable && !vcName.endsWith("?")) {
            vcName = String.valueOf(vcName) + '?';
        }
        I_Mem obj = (vcn0 = vcName.charAt(0)) >= 'A' && vcn0 <= 'Z' ? (I_Mem)current.getConstManager().use_ParseTime(parser, vcName, true) : (I_Mem)current.getVarManager().use_ParseTime(parser, vcName, true);
        obj.setType(type, parser.getDebugInfo());
        return new Group2<I_Object, String>(obj, rem);
    }

    private static enum STATE {
        TYPE,
        SPACE1,
        VARCONST,
        SPACE2,
        LET;

    }
}

