/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.pseudo;

import de.mn77.base.data.struct.BufferQueue;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;

public class MultiCall
extends A_Object {
    private final BufferQueue<I_Object> items = new BufferQueue();
    private final ArgCallBuffer arg;
    private boolean executed = false;
    private final int key;
    private I_Object stream = null;

    public MultiCall(int key, Call c) {
        this.key = key;
        this.arg = new ArgCallBuffer(0, c);
    }

    public void exec(CallRuntime cr, Block current, I_Object streamIT) {
        if (this.executed) {
            return;
        }
        this.executed = true;
        SimpleList<I_Object> il = cr.vce.useMultiCall().get(this.key);
        for (I_Object item : il) {
            this.items.add(item);
        }
    }

    public I_Object getCurrent() {
        return this.items.current();
    }

    public I_Object getNext() {
        return this.items.next();
    }

    public boolean hasNext() {
        return !this.items.isEmpty();
    }

    @Override
    public void init(CallRuntime cr) {
        this.arg.init(cr, this.stream, I_Object.class);
    }

    public void resetPointer() {
        this.items.reset();
    }

    public void setStream(I_Object o) {
        this.stream = o;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return "MultiCall";
            }
        }
        return "MultiCall(" + this.arg.toString(cr, STYPE.IDENT) + ")(" + this.items.toString() + ")";
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        throw Err.forbidden(cr);
    }
}

