/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.passthrough;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.object.passthrough.I_PassThrough;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.runtime.VarEnv;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Function;

public class Var
extends A_EventObject
implements I_PassThrough,
I_Mem {
    public static final String IT_FULL = "it?";
    public static final String IT = "it";
    public static final String CHANGED_EVENT = "@varChanged";
    private final String name;
    private final boolean nilable;
    private String initType = null;

    public Var(String name) {
        Err.ifNull((Object)name);
        int len = name.length();
        if (len >= 2 && name.charAt(len - 1) == '?') {
            this.name = name.substring(0, len - 1);
            this.nilable = true;
        } else {
            this.name = name;
            this.nilable = false;
        }
    }

    @Override
    public ObjectCallResult callEvent(CallRuntime cr, String event) {
        throw new CodeError(cr, "Invalid call of a event", "Got: " + event);
    }

    @Override
    public I_Object get(CallRuntime cr) {
        I_Object result = cr.vce.vars.get(cr, this);
        if (result == null) {
            if (this.nilable) {
                return Nil.NIL;
            }
            throw Lib_Error.memNotInitialized(cr, this);
        }
        return result;
    }

    @Override
    public final String getMemTypeString() {
        return "variable";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    public boolean isInitialized(CallRuntime cr) {
        return cr.vce.vars.isInitialized(this);
    }

    @Override
    public void let(CallRuntime crOld, CallRuntime crNew, I_Object o) {
        this.let(crOld, crNew, o, false);
    }

    @Override
    public void let(CallRuntime crOld, CallRuntime crNew, I_Object o, boolean convert) {
        if (this.initType != null) {
            crNew.vce.vars.setType(crNew, this, this.initType);
        }
        crNew.vce.vars.set(crOld, this, o, this.nilable, convert);
        this.eventRunRaw(crNew, CHANGED_EVENT, o);
    }

    @Override
    public I_Object mPrint(CallRuntime cr, boolean newline) {
        this.get(cr);
        return super.mPrint(cr, newline);
    }

    @Override
    public void setType(String type, DebugInfo debugInfo) {
        if (this.name.equals(IT)) {
            throw new CodeError("Invalid variable definition", "Can't set a fixed type for the already defined magic variable: " + this.name, debugInfo);
        }
        this.initType = type;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.initType != null && !this.name.equals(IT)) {
            sb.append('<');
            sb.append(this.initType);
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (type != STYPE.DESCRIBE) {
            return this.toString();
        }
        VarEnv ve = cr.vce.vars;
        if (!ve.isInitialized(this)) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        I_Object data = ve.get(cr, this);
        sb.append('[');
        sb.append(data.toString(cr, type));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        return event.equals(CHANGED_EVENT);
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "=": {
                this.mAssign(cr, false);
                return A_Object.stdResult(this);
            }
            case "~=": {
                this.mAssign(cr, true);
                return A_Object.stdResult(this);
            }
        }
        byte isVarFunction = Lib_Function.isVarFunction(method);
        if (isVarFunction > -1) {
            I_Object oldValue = cr.vce.vars.get(cr, this);
            if (oldValue == null) {
                throw new RuntimeError(cr, "Variable is not initialized", "The variable '" + this.name + "' has no value/type, please initialize it first.");
            }
            I_Object newValue = Lib_Function.mCalcLet(cr, method, isVarFunction, oldValue);
            this.let(cr, cr, newValue, true);
            return new ObjectCallResult(this, false);
        }
        return this.iCallValue(cr, method);
    }

    private ObjectCallResult iCallValue(CallRuntime cr, String method) {
        ObjectCallResult result = this.get(cr).call(cr);
        if (result == null || result.obj == null) {
            Err.invalid("Call returns no result!");
        }
        return result;
    }

    private void mAssign(CallRuntime cr, boolean convert) {
        VarLet streamit = new VarLet(this);
        I_Object arg = cr.args(streamit, I_Object.class)[0];
        this.let(cr, cr, arg, convert);
    }
}

