/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.magic.var;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import org.jaymo_lang.JayMo;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.magic.var.A_MagicVar;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;

public class MV_JAYMO
extends A_MagicVar {
    public static final String ID = "jaymo";

    public MV_JAYMO() {
        super(false);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "version": {
                String version = JayMo.version().toStringShort();
                return A_Object.stdResult(new Str(version));
            }
            case "exec": {
                cr.getStrict().checkSandbox(cr, "jaymo.exec");
                return A_Object.stdResult(this.mExec(cr));
            }
            case "run": {
                cr.getStrict().checkSandbox(cr, "jaymo.run");
                return A_Object.stdResult(this.mExecFile(cr));
            }
            case "allTypes": {
                cr.getStrict().checkSandbox(cr, "jaymo.allTypes");
                return A_Object.stdResult(this.mAllTypes(cr));
            }
        }
        return null;
    }

    private JMo_List mAllTypes(CallRuntime cr) {
        SimpleList<String> names = ObjectManager.allTypes(cr);
        SimpleList<I_Object> result = new SimpleList<I_Object>(names.size());
        for (String name : names) {
            result.add(new Str(name));
        }
        return new JMo_List(result);
    }

    private A_Immutable mExec(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String value = Lib_Convert.getStringValue(cr, arg);
        return Lib_Exec.execJayMo(cr, value, "jaymo.exec", null);
    }

    private A_Immutable mExecFile(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object target = cr.argTypeExt(args[0], Str.class, JMo_File.class);
        File file = Lib_Convert.getFile(cr, target);
        String[] argsArray = null;
        if (args.length == 2) {
            JMo_List targetArgs = (JMo_List)cr.argType(args[1], JMo_List.class);
            argsArray = Lib_Convert.toStringArray(targetArgs);
        }
        String script = null;
        try {
            script = Lib_TextFile.read(file);
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "File access error", "File: " + file.getAbsolutePath());
        }
        return Lib_Exec.execJayMo(cr, script, "jaymo.run", argsArray);
    }
}

