/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.magic.var;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.sys.file.MDir;
import de.mn77.base.sys.file.MFile;
import java.io.File;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_Dir;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.magic.I_MagicReplace;
import org.jaymo_lang.object.magic.var.A_MagicVar;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;

public class MV_APP
extends A_MagicVar
implements I_Object,
I_MagicReplace {
    public static final String ID = "app";

    public MV_APP() {
        super(false);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return type == STYPE.IDENT ? ID : "App";
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        cr.getApp().strict.checkSandbox(cr, ID);
        if (method.startsWith("::@")) {
            return cr.getApp().call(cr);
        }
        switch (method) {
            case "setOutput": {
                return A_Object.stdResult(this.mSetOutput(cr));
            }
            case "resetOutput": {
                return A_Object.stdResult(this.mResetOutput(cr));
            }
            case "setLogDir": {
                return A_Object.stdResult(this.mSetLogDir(cr));
            }
            case "setLogFile": {
                return A_Object.stdResult(this.mSetLogFile(cr));
            }
            case "args": {
                cr.argsNone();
                return A_Object.stdResult(cr.getApp().getArgs());
            }
            case "=": {
                return this.mExit(cr, 1, 1);
            }
            case "exit": {
                return this.mExit(cr, 0, 1);
            }
            case "keep": {
                return this.mKeep(cr);
            }
            case "exec": {
                return A_Object.stdResult(this.mExec(cr));
            }
        }
        return null;
    }

    private A_Immutable mExec(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String value = Lib_Convert.getStringValue(cr, arg);
        cr.getStrict().checkUnsafeHotCode(cr, "app.exec");
        return Lib_Exec.execJayMoHot(cr, value, "app.exec");
    }

    private ObjectCallResult mExit(CallRuntime cr, int parsMin, int parsMax) {
        I_Object[] args = cr.argsFlex(this, parsMin, parsMax);
        int exitState = 0;
        if (args.length == 1) {
            I_Object arg = cr.argType(args[0], Int.class);
            exitState = ((Int)arg).getValue();
        }
        App app = cr.getApp();
        app.exit(cr, exitState);
        return new ObjectCallResult(app, true);
    }

    private ObjectCallResult mKeep(CallRuntime cr) {
        cr.argsNone();
        cr.getApp().setKeep(cr);
        return new ObjectCallResult(this, false);
    }

    private I_Object mResetOutput(CallRuntime cr) {
        cr.argsNone();
        cr.getApp().setOutputFile(null);
        return this;
    }

    private I_Object mSetLogDir(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{JMo_Dir.class, Str.class}})[0];
        try {
            MDir dir = null;
            if (arg instanceof JMo_Dir) {
                File f = ((JMo_Dir)arg).getInternalFile();
                dir = new MDir(f);
            } else {
                String s = Lib_Convert.getStringValue(cr, arg);
                dir = new MDir(s);
            }
            MOut.setLogDir(dir);
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "Directory error", e.getMessage());
        }
        return this;
    }

    private I_Object mSetLogFile(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{JMo_File.class, Str.class}})[0];
        String filePath = arg instanceof Str ? Lib_Convert.getStringValue(cr, arg) : ((JMo_File)arg).getInternalFile().getAbsolutePath();
        File file = new File(filePath);
        MOut.setLogFile(file);
        return this;
    }

    private I_Object mSetOutput(CallRuntime cr) {
        I_Object[] args = cr.argsExt(this, {JMo_File.class, Str.class}, {Bool.class});
        String file = args[0] instanceof Str ? Lib_Convert.getStringValue(cr, args[0]) : ((JMo_File)args[0]).getInternalFile().getAbsolutePath();
        MFile file2 = new MFile(file);
        cr.getApp().setOutputFile(file2);
        boolean clear = ((Bool)args[1]).getValue();
        if (clear) {
            try {
                Lib_TextFile.set(cr.getApp().getOutputFile().getFile(), "");
            }
            catch (Err_FileSys e) {
                Err.show(e);
            }
        }
        return this;
    }
}

