/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object;

import de.mn77.base.data.struct.keypot.StringPotList;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.JayMoError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.util.Lib_Comply;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;

public abstract class A_EventObject
extends A_Object {
    private StringPotList<CallRuntime> eventHandlers;

    public final void eventAddHandler(CallRuntime cr, String event, Call c) {
        if (cr.argCount() != 0) {
            throw Err.impossible(cr, event, c);
        }
        if (this.eventHandlers == null) {
            this.eventHandlers = new StringPotList();
        }
        if (!this.validateEvent(cr, event)) {
            I_Object parent;
            if (this instanceof Instance && (parent = ((Instance)this).internalGetParent()) != null && parent instanceof A_EventObject) {
                ((A_EventObject)parent).eventAddHandler(cr, event, c);
                return;
            }
            if (event.indexOf(46) > -1) {
                throw new CodeError(cr, "Invalid event handler definition", "No attached stream allowed, but got: " + event);
            }
            if (!Lib_Comply.checkEventName(event)) {
                throw new CodeError(cr, "Invalid event name", "Got: " + event);
            }
            throw new CodeError(cr, "Unknown event", "Got handler for: " + event);
        }
        CallRuntime crNew = cr.copyEventHandler(c);
        this.eventHandlers.add(event, crNew);
    }

    public final boolean eventHasHandler(CallRuntime cr, String event) {
        if (this.eventHandlers == null) {
            return false;
        }
        Iterable<CallRuntime> pot = this.eventHandlers.get(event);
        return pot != null;
    }

    public final void eventRun(CallRuntime cr, String event, I_Object blockIT) {
        cr.getApp().registerFork();
        try {
            try {
                this.eventRunRaw(cr, event, blockIT);
            }
            catch (Throwable t) {
                Lib_Error.handleThreadErrorEnd(cr, t);
                cr.getApp().checkExit(true);
            }
        }
        finally {
            cr.getApp().checkExit(true);
        }
    }

    public final void eventRunRaw(CallRuntime cr, String event, I_Object blockIT) {
        Iterable<CallRuntime> handlers;
        Err.ifNull(cr, event, blockIT);
        if (!event.startsWith("@")) {
            throw new JayMoError(cr, "Invalid event name", "Leading @ is missing!");
        }
        if (this.eventHandlers != null && (handlers = this.eventHandlers.get(event)) != null) {
            for (CallRuntime eventCR : handlers) {
                I_Object result = Lib_Exec.execBlockStream(eventCR, blockIT);
                if (!(result instanceof Return)) continue;
                Lib_Exec.checkExceptionIsEnd(cr, (Return)result);
            }
        }
    }

    @Override
    public abstract void init(CallRuntime var1);

    public abstract boolean validateEvent(CallRuntime var1, String var2);

    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        char c0 = method.charAt(0);
        if (c0 == ':' && method.startsWith("::")) {
            String m = cr.call.method.substring(2);
            A_EventObject obj = this;
            I_Object o = Lib_Convert.getValue(cr, this);
            if (!(o instanceof A_EventObject)) {
                throw new CodeError(cr, "Invalid event-definition", "This object has no events: " + o);
            }
            obj = (A_EventObject)o;
            obj.eventAddHandler(cr, m, cr.call);
            return new ObjectCallResult(this, true);
        }
        if (c0 == '@') {
            if (cr.hasStream()) {
                throw new CodeError(cr, "Invalid call of a event", "Call of event " + method + " with stream");
            }
            if (cr.hasBlock()) {
                throw new CodeError(cr, "Invalid call of a event", "Call of event " + method + " with block");
            }
            if (this != cr.instance) {
                throw new CodeError(cr, "Invalid call of a event", "An event can only be started within the type definition: " + method);
            }
            if (this.validateEvent(cr, method)) {
                return this.callEvent(cr, method);
            }
            if (this instanceof Instance) {
                I_Object parent = ((Instance)this).internalGetParent();
                if (parent != null && parent instanceof A_EventObject) {
                    return ((A_EventObject)parent).call2(cr, method);
                }
            } else {
                throw new CodeError(cr, "Unknown event", "Event unknown and can't be started: " + method);
            }
        }
        return this.callMethod(cr, method);
    }

    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        throw new CodeError(cr, "Invalid call of a event", "This event can't be thrown this way: " + event);
    }

    protected abstract ObjectCallResult callMethod(CallRuntime var1, String var2);
}

