/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_RandomAccess;
import java.io.File;
import java.io.RandomAccessFile;

public class Lib_TextFileLow {
    public static void append(File file, String s) throws Err_FileSys {
        Err.ifNull(file, s);
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(raf.length());
                raf.writeBytes(s);
            }
            catch (Exception err) {
                throw Err.fsAccess(err, file, s);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }

    public static String read(File file) throws Err_FileSys {
        Err.ifNull((Object)file);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            StringBuilder sb = new StringBuilder(Lib_RandomAccess.checkReadSize(file, raf.length()));
            while (raf.getFilePointer() < raf.length()) {
                sb.append((char)raf.readByte());
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception err) {
            throw Err.fsAccess(err);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }

    public static void set(File file, String s) throws Err_FileSys {
        Lib_TextFileLow.write(file, null, s);
    }

    public static void write(File file, Long index, String s) throws Err_FileSys {
        Err.ifNull(file, s);
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                if (index == null) {
                    raf.setLength(0L);
                } else {
                    raf.seek(index);
                }
                raf.writeBytes(s);
            }
            catch (Exception err) {
                throw Err.fsAccess(err, file, s);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }
}

