/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.A_Comparable;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_WorldTime;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.data.type.datetime.format.FORM_DATE;
import de.mn77.base.data.type.datetime.format.FORM_TIME;
import de.mn77.base.data.type.datetime.format.FORM_WORLDTIME;
import de.mn77.base.data.util.Lib_Math;
import de.mn77.base.error.Err;
import java.util.GregorianCalendar;

public class MWorldTime
extends A_Comparable<I_WorldTime>
implements I_WorldTime {
    private final I_DateTime datetime;
    private final int utc_offset_msek;

    public MWorldTime() {
        this.datetime = new MDateTime();
        GregorianCalendar gc = new GregorianCalendar();
        this.utc_offset_msek = gc.get(15) + gc.get(16);
    }

    public MWorldTime(I_DateTime zeitpunkt, int utc_offset_std) {
        Err.ifNull((Object)zeitpunkt);
        this.datetime = zeitpunkt;
        Err.ifOutOfBounds(12.0, utc_offset_std);
        this.utc_offset_msek = utc_offset_std * 60 * 60 * 1000;
    }

    public MWorldTime(String text) {
        block18: {
            Err.ifEmpty(text);
            int laenge = text.length();
            Err.ifOutOfBounds(14, 31, laenge);
            if (laenge >= 29 && laenge <= 31 && text.matches("^[A-Z][a-z]{2}, [0-9]{2} [A-Z][a-z]{2} [0-9]{4} [0-9]{2}:[0-9]{2}:[0-9]{2} .*$")) {
                Integer m;
                Integer h;
                Integer monat = Lib_DateTime.parseMonth(FilterString.relCut(text, 9, 3));
                if (monat == null) {
                    Err.invalid("Unknown month", FilterString.relCut(text, 9, 3));
                }
                MDate datum = new MDate(Integer.parseInt(FilterString.relCut(text, 6, 2)), monat, Integer.parseInt(FilterString.relCut(text, 13, 4)));
                MTime uhrzeit = new MTime(FilterString.relCut(text, 18, 8));
                this.datetime = new MDateTime(datum, uhrzeit);
                String rest = FilterString.relCut(text, 27, false);
                if (rest.length() == 5 && rest.matches("^[\\+-][0-9]{4}$")) {
                    if (rest.charAt(0) != '+') {
                        Err.todo(new Object[0]);
                    }
                    h = Integer.parseInt(FilterString.relCut(rest, 2, 2));
                    m = Integer.parseInt(FilterString.relCut(rest, 4, 2));
                } else if (rest.length() == 4 && rest.matches("^[0-9]{4}$")) {
                    h = Integer.parseInt(FilterString.relCut(rest, 1, 2));
                    m = Integer.parseInt(FilterString.relCut(rest, 3, 2));
                } else {
                    if (rest.toUpperCase().equals("GMT")) {
                        h = 0;
                    } else if (rest.toUpperCase().equals("CEST")) {
                        h = 2;
                    } else if (rest.toUpperCase().equals("CET")) {
                        h = 1;
                    } else {
                        throw Err.invalid("Unknown time format!", text);
                    }
                    m = 0;
                }
                this.utc_offset_msek = (m + h * 60) * 60 * 1000;
                break block18;
            }
            if (text.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[\\+-][0-9]{2}:[0-9]{2}")) {
                MDateTime zp = new MDateTime(text.replaceFirst("T", " ").substring(0, 19));
                this.datetime = zp;
                if (text.charAt(19) != '+') {
                    Err.todo(new Object[0]);
                }
                Integer h = Integer.parseInt(FilterString.relCut(text, 21, 2));
                Integer m = Integer.parseInt(FilterString.relCut(text, 24, 2));
                this.utc_offset_msek = (m + h * 60) * 60 * 1000;
                break block18;
            }
            if (text.matches("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}")) {
                MDateTime zp = new MDateTime(text);
                this.datetime = zp;
                GregorianCalendar gc = new GregorianCalendar(zp.getYear(), zp.getMonth() - 1, zp.getDay(), zp.getHours(), zp.getMinutes(), zp.getSeconds());
                this.utc_offset_msek = gc.get(15) + gc.get(16);
                break block18;
            }
            throw Err.invalid("Unknown time format!", text);
        }
    }

    @Override
    public I_DateTime getDateTime() {
        return this.datetime;
    }

    @Override
    public int getDay() {
        return this.datetime.getDay();
    }

    @Override
    public int getDayOfWeek() {
        return this.datetime.getDayOfWeek();
    }

    @Override
    public int getHours() {
        return this.datetime.getDay();
    }

    @Override
    public int getMilliSeconds() {
        throw Err.todo(this);
    }

    @Override
    public int getMinutes() {
        return this.datetime.getDay();
    }

    @Override
    public int getMonth() {
        return this.datetime.getDay();
    }

    @Override
    public int getSeconds() {
        return this.datetime.getDay();
    }

    @Override
    public int getUTC_Offset_MSek() {
        return this.utc_offset_msek;
    }

    @Override
    public long getValueMilliSeconds() {
        throw Err.todo(this);
    }

    @Override
    public int getYear() {
        return this.datetime.getDay();
    }

    @Override
    public boolean isEqual(I_WorldTime zeit) {
        return this.datetime.isEqual(zeit.getDateTime()) && this.utc_offset_msek == zeit.getUTC_Offset_MSek();
    }

    @Override
    public boolean isGreater(I_WorldTime zeit) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public String toString() {
        return this.toStringDefault();
    }

    @Override
    public String toString(Object ... format) {
        String result = "";
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                result = String.valueOf(result) + o;
            } else if (o instanceof FORM_DATE || o instanceof FORM_TIME) {
                result = String.valueOf(result) + this.datetime.toString(o);
            } else if (o == FORM_WORLDTIME.GMT_5) {
                int gmt_min = Lib_Math.absBetrag(this.utc_offset_msek) / 1000 / 60;
                result = String.valueOf(result) + (this.utc_offset_msek >= 0 ? "+" : "-");
                int h = gmt_min / 60;
                int m = gmt_min - h * 60;
                result = String.valueOf(result) + FormNumber.width(2, Lib_Math.roundDown(h), false);
                result = String.valueOf(result) + FormNumber.width(2, Lib_Math.roundDown(m), false);
            } else {
                Err.invalid(o);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String toStringDE() {
        throw Err.todo(this);
    }

    @Override
    public String toStringDefault() {
        return this.toStringRFC822();
    }

    @Override
    public String toStringFileSysSlim() {
        throw Err.todo(this);
    }

    @Override
    public String toStringFileSysWide() {
        throw Err.todo(this);
    }

    @Override
    public String toStringRFC822() {
        return this.toString(FORM_WORLDTIME.GROUP_RFC822);
    }

    @Override
    public String toStringShort() {
        throw Err.todo(this);
    }

    @Override
    public boolean usesMilliSeconds() {
        throw Err.todo(this);
    }
}

