/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.convert;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.search.SearchText;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ConvertString {
    public static String[] csvLineToString(String line, char delimiter_field, char delimiter_col) {
        ArrayList<String> result = new ArrayList<String>();
        boolean open = false;
        boolean double_tf = false;
        String field = "";
        int p = 0;
        while (p < line.length()) {
            boolean last;
            char c = line.charAt(p);
            boolean bl = last = p == line.length() - 1;
            if (c == delimiter_field) {
                if (double_tf) {
                    double_tf = false;
                    field = String.valueOf(field) + c;
                } else if (open) {
                    if (last || line.charAt(p + 1) != delimiter_field) {
                        open = false;
                    } else {
                        double_tf = true;
                    }
                } else {
                    open = true;
                }
            } else if (!open && c == delimiter_col) {
                result.add(field);
                field = "";
                if (last) {
                    result.add("");
                }
            } else {
                field = String.valueOf(field) + c;
            }
            ++p;
        }
        if (field.length() > 0) {
            result.add(field);
        }
        return result.toArray(new String[result.size()]);
    }

    public static TypeTable2<String, Boolean> splitToTable(String s, String ... delimiters) {
        TypeTable2<String, Boolean> result = new TypeTable2<String, Boolean>(String.class, Boolean.class);
        TypeTable2<Integer, String> tab = SearchText.indexesMulti(s, delimiters);
        int start = 0;
        int rowIndex = 0;
        while (rowIndex < tab.size()) {
            int delimiterIndex = (Integer)tab.getColumn0().get(rowIndex);
            String delimiter = (String)tab.getColumn1().get(rowIndex);
            int end = delimiterIndex;
            if (start <= end) {
                result.add(s.substring(start, end), false);
            }
            result.add(delimiter, true);
            start = delimiterIndex + delimiter.length();
            ++rowIndex;
        }
        if (start < s.length()) {
            result.add(s.substring(start), false);
        }
        return result;
    }

    public static Boolean toBoolean(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Integer toInteger(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static HashSet<String> toItemSet(char[] delimiters, String s) {
        String part;
        Err.ifNull((Object)s);
        s = s.trim();
        HashSet<String> result = new HashSet<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 0;
        int pos = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            char[] cArray2 = delimiters;
            int n3 = delimiters.length;
            int n4 = 0;
            while (n4 < n3) {
                char d = cArray2[n4];
                if (d == c) {
                    String part2 = s.substring(start, pos).trim();
                    if (part2.length() > 0) {
                        result.add(part2);
                    }
                    start = pos + 1;
                    break;
                }
                ++n4;
            }
            ++pos;
            ++n2;
        }
        if (start < pos && (part = s.substring(start, pos).trim()).length() > 0) {
            result.add(part);
        }
        return result;
    }

    public static List<String> toLines(String s) {
        Err.ifNull((Object)s);
        SimpleList<String> result = new SimpleList<String>();
        int start = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                result.add(s.substring(start, i));
                start = i + 1;
            }
            ++i;
        }
        if (start < s.length()) {
            result.add(s.substring(start));
        }
        return result;
    }

    public static List<String> toList(char delimiter, String s) {
        Err.ifNull((Object)s);
        ArrayList<String> result = new ArrayList<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 0;
        int pos = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == delimiter) {
                result.add(s.substring(start, pos));
                start = pos + 1;
            }
            ++pos;
            ++n2;
        }
        if (start < pos) {
            result.add(s.substring(start, pos));
        }
        if (start == pos && s.charAt(pos - 1) == delimiter) {
            result.add("");
        }
        return result;
    }

    public static List<String> toList(String delimiter, String s) {
        Err.ifEmpty(delimiter);
        Err.ifNull((Object)s);
        SimpleList<String> result = new SimpleList<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 1;
        if (s.indexOf(delimiter) == 0) {
            result.add("");
        } else {
            start -= delimiter.length();
        }
        while (start <= s.length()) {
            int nt = s.indexOf(delimiter, (start += delimiter.length()) - 1) + 1;
            if (nt < 1) {
                nt = s.length() + 1;
            }
            if (start > s.length()) {
                result.add("");
            } else {
                result.add(FilterString.relCut(s, start, nt - start));
            }
            start += nt - start;
        }
        return result;
    }

    public static <T> T toObject(String s, Class<T> c) {
        if (s == null) {
            return null;
        }
        Err.ifNull(c);
        if (c == String.class) {
            return (T)s;
        }
        if (c == Integer.class) {
            return (T)Integer.valueOf(Integer.parseInt(s));
        }
        if (c == I_Date.class) {
            return (T)new MDate(s);
        }
        if (c == Boolean.class) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(s));
        }
        if (c == I_DateTime.class) {
            return (T)new MDateTime(s);
        }
        throw Err.todo("Unknown Class to convert", s, c);
    }

    public static ArrayList<String> toSearchWords(String s) {
        String word;
        Err.ifNull((Object)s);
        s = s.trim();
        ArrayList<String> result = new ArrayList<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 0;
        int pos = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ' ') {
                String word2 = s.substring(start, pos).trim();
                if (word2.length() > 0) {
                    result.add(word2);
                }
                start = pos + 1;
            }
            ++pos;
            ++n2;
        }
        if (start < pos && (word = s.substring(start, pos).trim()).length() > 0) {
            result.add(word);
        }
        return result;
    }

    public static String[] toStringArray(char delimiter, String s) {
        List<String> c = ConvertString.toList(delimiter, s);
        return c.toArray(new String[c.size()]);
    }

    public static String[] toStringArray(String delimiter, String s) {
        List<String> c = ConvertString.toList(delimiter, s);
        return c.toArray(new String[c.size()]);
    }

    public static Iterable<String> toWords(String s) {
        SimpleList<String> result = new SimpleList<String>();
        int len = s.length();
        int start = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z' && c < '\u00c0' || c > '\u00ff') {
                if (i != start) {
                    String word = s.substring(start, i);
                    result.add(word);
                }
                start = i + 1;
            }
            ++i;
        }
        if (start < len) {
            String word = s.substring(start);
            result.add(word);
        }
        return result;
    }

    public static Iterable<String> toWords(String s, char[] delimiters) {
        SimpleList<String> result = new SimpleList<String>();
        int len = s.length();
        int start = 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            char[] cArray = delimiters;
            int n = delimiters.length;
            int n2 = 0;
            while (n2 < n) {
                char tr = cArray[n2];
                if (tr == c) {
                    if (i != start) {
                        String word = s.substring(start, i);
                        result.add(word);
                    }
                    start = i + 1;
                    break;
                }
                ++n2;
            }
            ++i;
        }
        if (start < len) {
            String word = s.substring(start);
            result.add(word);
        }
        return result;
    }
}

