/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.container;

import de.mn77.base.data.container.I_Box;
import de.mn77.base.data.struct.SimpleQueue;

public final class Bottleneck<T>
implements I_Box<T> {
    private T value = null;
    private SimpleQueue<Thread> waitlist = new SimpleQueue();
    private int count = 0;

    public Bottleneck() {
    }

    public Bottleneck(T startvalue) {
        this();
        this.value = startvalue;
    }

    @Override
    public synchronized T get() {
        this.lock();
        T result = this.value;
        this.unlock();
        return result;
    }

    @Override
    public synchronized void set(T t) {
        this.lock();
        this.value = t;
        this.unlock();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.get() + ")";
    }

    private synchronized void lock() {
        if (this.count > 0) {
            Thread t = Thread.currentThread();
            this.waitlist.add(t);
            try {
                t.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ++this.count;
    }

    private synchronized void unlock() {
        --this.count;
        if (this.count > 0) {
            this.waitlist.next().notify();
        }
    }
}

