/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.bigcalc;

import de.mn77.base.data.bigcalc.BigPowerIterator;
import de.mn77.base.data.bigcalc.BigPowerNIterator;
import de.mn77.base.data.bigcalc.BigRational;
import de.mn77.base.data.bigcalc.BigSeriesCalculator;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigExpCalculator
extends BigSeriesCalculator {
    public static final BigExpCalculator INSTANCE = new BigExpCalculator();
    private int n = 0;
    private BigRational oneOverFactorialOfN = BigRational.ONE;

    private BigExpCalculator() {
    }

    @Override
    protected void calculateNextFactor() {
        ++this.n;
        this.oneOverFactorialOfN = this.oneOverFactorialOfN.divide(this.n);
    }

    @Override
    protected BigPowerIterator createPowerIterator(BigDecimal x, MathContext mathContext) {
        return new BigPowerNIterator(x, mathContext);
    }

    @Override
    protected BigRational getCurrentFactor() {
        return this.oneOverFactorialOfN;
    }
}

