/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor;

import de.mn77.base.data.group.Section;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import org.jaymo_lang.edit.editor.border.LineNumberedBorder;
import org.jaymo_lang.edit.editor.funcs.Fn_Comment;
import org.jaymo_lang.edit.editor.funcs.Fn_DelLine;
import org.jaymo_lang.edit.editor.funcs.Fn_Indent;
import org.jaymo_lang.edit.editor.funcs.Fn_MoveLines;
import org.jaymo_lang.edit.editor.funcs.Fn_Occurrences;
import org.jaymo_lang.edit.editor.funcs.Fn_UndoRedo;
import org.jaymo_lang.edit.editor.styler.I_Styler;
import org.jaymo_lang.util.Lib_Parser;

public class CodeEditor
extends JTextPane {
    private static final long serialVersionUID = -1801145479677890566L;
    public static final boolean DEMO = false;
    private static final Color LINE_HIGHLIGHT_COLOR = new Color(238, 238, 238, 255);
    private I_Styler style = null;
    private int caretYcurrent = 0;
    private int currentLineHeight;
    private final Fn_UndoRedo history = new Fn_UndoRedo();

    public CodeEditor(int font_char_width, int font_line_hight) {
        this.currentLineHeight = font_line_hight;
        this.setEditable(true);
        this.setOpaque(false);
        this.setBorder(new LineNumberedBorder());
        this.history.init(this);
        new Fn_DelLine().init(this);
        new Fn_Indent().init(this);
        new Fn_MoveLines().init(this);
        new Fn_Occurrences().init(this);
        new Fn_Comment().init(this);
        TabStop[] tabs = new TabStop[20];
        int tabWidth = font_char_width * 4;
        int i = 0;
        while (i < tabs.length) {
            tabs[i] = new TabStop((i + 1) * tabWidth, 0, 0);
            ++i;
        }
        TabSet tabset = new TabSet(tabs);
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.TabSet, tabset);
        this.setParagraphAttributes(aset, false);
        this.addCaretListener(e -> {
            int caret = this.getCaretPosition();
            if (caret >= 0) {
                try {
                    Rectangle2D r = this.getUI().modelToView2D(this, caret, Position.Bias.Forward);
                    if (this.currentLineHeight > 0) {
                        this.repaint(0, this.caretYcurrent, this.getWidth(), this.currentLineHeight);
                    }
                    if (r != null && r.getHeight() > 0.0) {
                        this.caretYcurrent = (int)r.getY();
                        this.currentLineHeight = (int)r.getHeight();
                        this.repaint(0, (int)r.getY(), this.getWidth(), (int)r.getHeight());
                    } else {
                        this.currentLineHeight = -1;
                    }
                }
                catch (BadLocationException err) {
                    Err.show((Throwable)err);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void keyReleased(KeyEvent e) {
                block4: {
                    if (e.getKeyCode() != 10 || e.getModifiersEx() != 0) break block4;
                    text = CodeEditor.this.getText();
                    base = CodeEditor.this.getCaretPosition();
                    startBefore = base - 2;
                    if (text.length() != 0) ** GOTO lbl8
                    return;
lbl-1000:
                    // 1 sources

                    {
                        --startBefore;
lbl8:
                        // 2 sources

                        ** while (startBefore > 0 && text.charAt((int)startBefore) != '\n')
                    }
lbl9:
                    // 1 sources

                    lineBefore = text.substring(startBefore + 1, base - 1);
                    indent = Lib_Parser.getDepth((String)lineBefore);
                    if (indent > 0) {
                        try {
                            CodeEditor.this.getDocument().insertString(base, Lib_String.sequence((char)'\t', (long)indent), null);
                        }
                        catch (BadLocationException err) {
                            Err.show((Throwable)err);
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void find(String find) {
        if (this.style != null) {
            this.style.paintFind(find);
        }
    }

    public Fn_UndoRedo getHistory() {
        return this.history;
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    public void occurrences(ArrayList<Section> mark) {
        if (this.style != null) {
            if (mark != null) {
                this.style.paintOccurrences(mark);
            } else {
                this.style.repaint();
            }
        }
    }

    public void setCode(String code) {
        this.setText(code);
    }

    public void setStyler(I_Styler style) {
        this.style = style;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.currentLineHeight > 0) {
            g.setColor(LINE_HIGHLIGHT_COLOR);
            g.fillRect(0, this.caretYcurrent, this.getWidth(), this.currentLineHeight);
        }
        super.paintComponent(g);
        if (this.style != null) {
            this.style.paintStyles();
        }
    }
}

