/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.cli;

import de.mn77.base.data.convert.ConvertArray;
import de.mn77.base.data.util.Lib_Array;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import java.io.IOException;
import org.jaymo_lang.JayMo;
import org.jaymo_lang.cli.Main_CLI;
import org.jaymo_lang.cli.info.Lib_CliInfo;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_App;
import org.jaymo_lang.util.Lib_Error;

public class Main_JayMo {
    private boolean parseOnly = false;
    private String directExec = null;
    private boolean directExecResult = false;
    private boolean debug = false;

    public static void main(String[] args) {
        MOut.reset();
        MOut.setJavaErrors((boolean)false);
        try {
            Main_JayMo jmo = new Main_JayMo();
            jmo.start(args);
        }
        catch (Throwable t) {
            Err.exit((Throwable)Lib_Error.wrap((Throwable)t));
        }
    }

    public void start(String[] args) throws Err_FileSys, IOException {
        if ((args = this.iParseArgs(args)) == null) {
            return;
        }
        if (args.length == 0 && this.directExec == null) {
            this.iStartCLI();
        } else {
            this.iDirectExec(args);
        }
    }

    private void iDirectExec(String[] args) throws Err_FileSys {
        Parser_App parser = new Parser_App(false);
        if (this.debug) {
            parser.setDebug();
        }
        App app = null;
        if (this.directExec != null) {
            app = parser.parseText(this.directExec.trim());
        } else {
            MFile file = new MFile(args[0]);
            if (!file.exists()) {
                MOut.print((String)("Missing file: " + file.getPathAbsolute()));
                return;
            }
            app = parser.parseFile(file.getFile());
            args = Lib_Array.cutFrom((String[])args, (int)1);
        }
        if (this.parseOnly) {
            MOut.print((String)"Test okay, no parse errors found.");
        } else {
            String result = app.exec(args);
            if (this.directExecResult && result != null) {
                MOut.print((String)("Result: " + result));
            }
        }
    }

    private String[] iParseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            if (!s.startsWith("-")) {
                return Lib_Array.cutFrom((String[])args, (int)i);
            }
            switch (s) {
                case "-t": 
                case "--test": {
                    this.parseOnly = true;
                    break;
                }
                case "--debug": 
                case "-d": {
                    this.debug = true;
                    MOut.setJavaErrors((boolean)true);
                    MOut.setDebug();
                    break;
                }
                case "-E": 
                case "--execout": {
                    this.directExecResult = true;
                }
                case "-e": 
                case "--exec": {
                    int len = args.length - i - 1;
                    if (len == 0) {
                        throw new Err_Runtime("Invalid arguments", new Object[]{"Missing code "});
                    }
                    this.directExec = ConvertArray.toString((String)" ", (Object[])Lib_Array.cutFrom((String[])args, (int)(++i)));
                    break;
                }
                case "--license": {
                    String licenseMessage = "JayMo  Copyright (C):  2017-2022  Michael Nitsche (DE, \u00dcbersee)\n\n" + Lib_CliInfo.license();
                    MOut.print((String)licenseMessage);
                    return null;
                }
                case "--version": {
                    MOut.print((String)("JayMo  " + new Parser_App().getVersionString(JayMo.STAGE.isDevelopment(), false)));
                    return null;
                }
                case "--help": {
                    MOut.print((Object[])new Object[]{Lib_CliInfo.help()});
                    return null;
                }
                default: {
                    throw new Err_Runtime("Unknown argument for JayMo", new Object[]{s});
                }
            }
            ++i;
        }
        return new String[0];
    }

    private void iStartCLI() throws Err_FileSys, IOException {
        Main_CLI cli = new Main_CLI();
        cli.start(this.parseOnly, this.debug);
    }
}

