/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.graphic;

import de.mn77.base.MN;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.util.Lib_Math;
import de.mn77.base.error.Err;
import de.mn77.lib.graphic.I_Image;
import de.mn77.lib.graphic.MImage;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class Lib_Graphic {
    public static Point calcRatio(int width, int height) {
        int max;
        Err.ifTooSmall((double)1.0, (double)width);
        Err.ifTooSmall((double)1.0, (double)height);
        int i = max = ((Integer)Lib_Math.max((Comparable[])new Integer[]{width, height})).intValue();
        while (i > 1) {
            if (width % i == 0 && height % i == 0) {
                return new Point(width / i, height / i);
            }
            --i;
        }
        return new Point(width, height);
    }

    public static Point calcResize(int source_dx, int source_dy, int dest_dx, int dest_dy) {
        int nx;
        int ny;
        if (dest_dx == 0 && dest_dy == 0) {
            return new Point(source_dx, source_dy);
        }
        if (dest_dx == 0 || dest_dx < 0 && dest_dy > 0) {
            ny = Math.abs(dest_dy);
            nx = Math.round((float)source_dx * (float)ny / (float)source_dy);
        } else {
            nx = Math.abs(dest_dx);
            ny = Math.round((float)source_dy * (float)nx / (float)source_dx);
        }
        if (dest_dx <= 0 && dest_dy < 0 && ny < Math.abs(dest_dy) || dest_dx > 0 && dest_dy > 0 && ny > Math.abs(dest_dy)) {
            ny = Math.abs(dest_dy);
            nx = Math.round((float)source_dx * (float)ny / (float)source_dy);
        }
        return new Point(nx, ny);
    }

    public static int[] HSBtoRGB(float hue, float saturation, float value) {
        return Lib_Graphic.HSVtoRGB(hue, saturation, value);
    }

    public static int[] HSLtoRGB(float h, float s, float l) {
        Err.ifOutOfBounds((double)0.0, (double)360.0, (double[])new double[]{h});
        Err.ifOutOfBounds((double)0.0, (double)1.0, (double[])new double[]{s});
        Err.ifOutOfBounds((double)0.0, (double)1.0, (double[])new double[]{l});
        float m2 = (double)l <= 0.5 ? l * (s + 1.0f) : l + s - l * s;
        float m1 = l * 2.0f - m2;
        int r = Math.round(255.0f * Lib_Graphic.hueToRGB(m1, m2, (h /= 360.0f) + 0.33333334f));
        int g = Math.round(255.0f * Lib_Graphic.hueToRGB(m1, m2, h));
        int b = Math.round(255.0f * Lib_Graphic.hueToRGB(m1, m2, h - 0.33333334f));
        return new int[]{r, g, b};
    }

    public static int[] HSVtoRGB(float hue, float saturation, float value) {
        Err.ifOutOfBounds((double)0.0, (double)360.0, (double[])new double[]{hue});
        Err.ifOutOfBounds((double)0.0, (double)1.0, (double[])new double[]{saturation});
        Err.ifOutOfBounds((double)0.0, (double)1.0, (double[])new double[]{value});
        Color c = Color.getHSBColor(hue / 360.0f, saturation, value);
        return new int[]{c.getRed(), c.getGreen(), c.getBlue()};
    }

    @Deprecated
    public static int[] int2rgb(int rgb) {
        int b = rgb / 255 / 255;
        int g = (rgb -= b * 255 * 255) / 255;
        int r = rgb -= g * 255;
        return new int[]{r, g, b};
    }

    public static I_Image mask(I_Image image1, I_Image image2, I_Image maske) {
        int breite = image1.getWidth();
        int hoehe = image1.getHeight();
        Err.ifNot((Object)breite, (Object)image2.getWidth());
        Err.ifNot((Object)hoehe, (Object)image2.getHeight());
        Err.ifNot((Object)breite, (Object)maske.getWidth());
        Err.ifNot((Object)hoehe, (Object)maske.getHeight());
        WritableRaster raster1 = ((BufferedImage)image1.getImage()).getRaster();
        WritableRaster raster2 = ((BufferedImage)image2.getImage()).getRaster();
        WritableRaster raster3 = ((BufferedImage)maske.getImage()).getRaster();
        BufferedImage ergbuffi = new BufferedImage(breite, hoehe, 1);
        WritableRaster raster4 = ergbuffi.getRaster();
        int[] pixel1rgb = new int[4];
        int[] pixel2rgb = new int[4];
        int[] pixel3rgb = new int[4];
        int[] pixel4rgb = new int[4];
        int y = 0;
        while (y < hoehe) {
            int x = 0;
            while (x < breite) {
                raster1.getPixel(x, y, pixel1rgb);
                raster2.getPixel(x, y, pixel2rgb);
                raster3.getPixel(x, y, pixel3rgb);
                double anteil_r = (double)pixel3rgb[0] / 255.0;
                double anteil_g = (double)pixel3rgb[1] / 255.0;
                double anteil_b = (double)pixel3rgb[2] / 255.0;
                double anteil_a = (double)pixel3rgb[3] / 255.0;
                pixel4rgb[0] = (int)((double)pixel1rgb[0] * anteil_r + (double)pixel2rgb[0] * (1.0 - anteil_r));
                pixel4rgb[1] = (int)((double)pixel1rgb[1] * anteil_g + (double)pixel2rgb[1] * (1.0 - anteil_g));
                pixel4rgb[2] = (int)((double)pixel1rgb[2] * anteil_b + (double)pixel2rgb[2] * (1.0 - anteil_b));
                pixel4rgb[3] = (int)((double)pixel1rgb[3] * anteil_a + (double)pixel2rgb[3] * (1.0 - anteil_a));
                raster4.setPixel(x, y, pixel4rgb);
                ++x;
            }
            ++y;
        }
        return new MImage(ergbuffi);
    }

    public static Point position(int canvas_dx, int canvas_dy, int image_dx, int image_dy, POSITION position) {
        int diff_x = canvas_dx - image_dx;
        int diff_y = canvas_dy - image_dy;
        int result_x = 0;
        int result_y = 0;
        if (MN.or((Object)position, (Object[])new Object[]{POSITION.LEFT, POSITION.TOP_LEFT, POSITION.BOTTOM_LEFT})) {
            result_x = 0;
        }
        if (MN.or((Object)position, (Object[])new Object[]{POSITION.TOP, POSITION.CENTER, POSITION.BOTTOM})) {
            result_x = diff_x / 2;
        }
        if (MN.or((Object)position, (Object[])new Object[]{POSITION.RIGHT, POSITION.TOP_RIGHT, POSITION.BOTTOM_RIGHT})) {
            result_x = diff_x;
        }
        if (MN.or((Object)position, (Object[])new Object[]{POSITION.TOP_LEFT, POSITION.TOP, POSITION.TOP_RIGHT})) {
            result_y = 0;
        }
        if (MN.or((Object)position, (Object[])new Object[]{POSITION.LEFT, POSITION.CENTER, POSITION.RIGHT})) {
            result_y = diff_y / 2;
        }
        if (MN.or((Object)position, (Object[])new Object[]{POSITION.BOTTOM_LEFT, POSITION.BOTTOM, POSITION.BOTTOM_RIGHT})) {
            result_y = diff_y;
        }
        return new Point(result_x, result_y);
    }

    @Deprecated
    public static int rgb2int(int r, int g, int b) {
        return r + 256 * g + 65536 * b;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        return Lib_Graphic.RGBtoHSB(r, g, b);
    }

    public static float[] RGBtoHSL(int r, int g, int b) {
        float ir = (float)r / 255.0f;
        float ig = (float)g / 255.0f;
        float ib = (float)b / 255.0f;
        float min = ((Float)Lib_Math.min((Comparable[])new Float[]{Float.valueOf(ir), Float.valueOf(ig), Float.valueOf(ib)})).floatValue();
        float max = ((Float)Lib_Math.max((Comparable[])new Float[]{Float.valueOf(ir), Float.valueOf(ig), Float.valueOf(ib)})).floatValue();
        float maxmin = max - min;
        float l = (max + min) / 2.0f;
        float h = 0.0f;
        float s = 0.0f;
        if (maxmin != 0.0f) {
            s = (double)l < 0.5 ? maxmin / (max + min) : maxmin / (2.0f - max - min);
            float dr = ((max - ir) / 6.0f + maxmin / 2.0f) / maxmin;
            float dg = ((max - ig) / 6.0f + maxmin / 2.0f) / maxmin;
            float db = ((max - ib) / 6.0f + maxmin / 2.0f) / maxmin;
            if (ir == max) {
                h = db - dg;
            } else if (ig == max) {
                h = 0.33333334f + dr - db;
            } else if (ib == max) {
                h = 0.6666667f + dg - dr;
            }
            if (h < 0.0f) {
                h += 1.0f;
            }
            if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        return new float[]{h * 360.0f, s, l};
    }

    public static float[] RGBtoHSV(int r, int g, int b) {
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{r});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{g});
        Err.ifOutOfBounds((int)0, (int)255, (int[])new int[]{b});
        float[] f = Color.RGBtoHSB(r, g, b, null);
        f[0] = f[0] * 360.0f;
        return f;
    }

    public static I_Image screenshot() {
        BufferedImage bi = null;
        try {
            bi = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        }
        catch (HeadlessException e) {
            Err.wrap((RuntimeException)e, (Object[])new Object[0]);
        }
        catch (AWTException e) {
            Err.wrap((Exception)e, (Object[])new Object[0]);
        }
        return new MImage(bi);
    }

    public static Point verhaeltnis(int max_x, int max_y, int wie_x, int wie_y) {
        Err.ifTooSmall((double)1.0, (double)max_x);
        Err.ifTooSmall((double)1.0, (double)max_y);
        Err.ifTooSmall((double)1.0, (double)wie_x);
        Err.ifTooSmall((double)1.0, (double)wie_y);
        Point v = Lib_Graphic.calcRatio(wie_x, wie_y);
        while (max_x > 0 && (max_x % v.x != 0 || max_x * v.y % v.x != 0 || max_x * v.y / v.x > max_y)) {
            --max_x;
        }
        return new Point(max_x, max_x * v.y / v.x);
    }

    private static float hueToRGB(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return m1 + (m2 - m1) * h * 6.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2;
        }
        if (h * 3.0f < 2.0f) {
            return m1 + (m2 - m1) * (0.6666667f - h) * 6.0f;
        }
        return m1;
    }
}

