/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.config;

import de.mn77.base.data.convert.ConvertObject;
import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.lib.config.I_PropertiesFile_Read;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Set;

public class PropertiesFile
implements I_PropertiesFile_Read {
    private Properties prop;
    private final String title;
    private final File file;

    public PropertiesFile(String title, File file) {
        Err.ifNull((Object)file);
        this.prop = new Properties();
        this.file = file;
        this.title = title;
    }

    public void close() throws Err_FileSys {
        this.write();
        this.prop = null;
    }

    public I_List<String> getAllKeys() {
        this.iCheckClosed();
        Set<Object> keys = this.prop.keySet();
        SimpleList result = new SimpleList();
        keys.forEach(arg_0 -> PropertiesFile.lambda$0((I_List)result, arg_0));
        return result;
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBooleanOrDefault(key, null);
    }

    @Override
    public Boolean getBooleanOrDefault(String key, Boolean defaultValue) {
        return ConvertString.toBoolean((String)this.getStringOrDefault(key, "" + defaultValue));
    }

    @Override
    public Integer getInteger(String key) {
        return this.getIntegerOrDefault(key, null);
    }

    @Override
    public Integer getIntegerOrDefault(String key, Integer defaultValue) {
        return ConvertString.toInteger((String)this.getStringOrDefault(key, "" + defaultValue));
    }

    @Override
    public String getString(String key) {
        return this.getStringOrDefault(key, null);
    }

    @Override
    public String getStringOrDefault(String key, String defaultValue) {
        this.iCheckClosed();
        return this.prop.getProperty(this.iNormalizeKey(key), defaultValue);
    }

    public void read() throws Err_FileSys {
        this.read(false);
    }

    public void read(boolean mustExist) throws Err_FileSys {
        this.iCheckClosed();
        InputStreamReader isr = null;
        try {
            try {
                if (this.file.exists()) {
                    isr = new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
                    this.prop.load(isr);
                } else if (mustExist) {
                    throw Err.fsFailed((Object[])new Object[]{"File is missing", this.file});
                }
            }
            catch (IOException e) {
                throw Err.wrap((IOException)e, (Object[])new Object[]{"Can't read properties file."});
            }
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {
                Err.show((Throwable)e);
            }
        }
    }

    public void removeKey(String key) {
        this.iCheckClosed();
        this.prop.remove(key);
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.setString(key, ConvertObject.toText((Object)value));
    }

    @Override
    public void setInteger(String key, Integer value) {
        this.setString(key, ConvertObject.toText((Object)value));
    }

    @Override
    public void setString(String key, String value) {
        Err.ifNull((Object[])new Object[]{key, value});
        this.iCheckClosed();
        this.prop.setProperty(this.iNormalizeKey(key), value);
    }

    public void write() throws Err_FileSys {
        this.iCheckClosed();
        OutputStreamWriter osw = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(this.file);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                this.prop.store(osw, this.title);
            }
            catch (Exception e) {
                throw Err.fsFailed((Object[])new Object[]{e, "Can't write properties file"});
            }
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                Err.show((Throwable)e);
            }
        }
    }

    private void iCheckClosed() {
        if (this.prop == null) {
            throw new Err_Runtime("This properties file is finally closed!", new Object[0]);
        }
    }

    private String iNormalizeKey(String key) {
        Err.ifNull((Object)key);
        return FilterString.only((char[])(String.valueOf("abcdefghijklmnopqrstuvwxyz".toLowerCase()) + "0123456789" + "_.-").toCharArray(), (String)key.toLowerCase());
    }

    private static /* synthetic */ void lambda$0(I_List i_List, Object key) {
        i_List.add((Object)((String)key));
    }
}

