/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.atomic.IntList;
import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;

public class ScriptFilter {
    private StringBuilder currentLine = null;
    private final SimpleList<String> lines = new SimpleList();
    private final IntList lineNr = new IntList();

    public Group2<String[], int[]> filter(String filepath, String s) {
        if (!this.lines.isEmpty()) {
            throw Err.invalid("Filter is already done!");
        }
        boolean openText = false;
        boolean openString = false;
        boolean openChar = false;
        boolean openCmd = false;
        boolean openTree = false;
        boolean openTable = false;
        boolean ignoreChar = false;
        boolean commentLine = false;
        boolean commentBlock = false;
        boolean abort = false;
        boolean trimLeftSpace = false;
        boolean treeKeyCombine = false;
        int lineIndent = 0;
        int doubleQuotes = 0;
        int abortPart = 0;
        int countGreater = 0;
        int countLesser = 0;
        int countPipe = 0;
        char last1 = '\n';
        char last2 = '\n';
        char[] ca = s.toCharArray();
        int len = ca.length;
        this.currentLine = null;
        int currentLineNr = 1;
        int idx = -1;
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            ++idx;
            if (ignoreChar) {
                this.append(c);
                ignoreChar = false;
                last2 = last1;
                last1 = c;
            } else if ((commentLine || commentBlock) && c != '\n' && c != '*' && c != '#' && c != '/') {
                abortPart = 0;
                last2 = last1;
                last1 = c;
            } else if (openText) {
                if (c == '\"') {
                    if ((doubleQuotes = (int)((byte)(doubleQuotes + 1))) == 4) {
                        openText = false;
                        doubleQuotes = 0;
                        this.currentLine = new StringBuilder(this.currentLine.substring(0, this.currentLine.length() - 6));
                        this.currentLine.append('\"');
                    } else {
                        this.append("\\\"");
                    }
                } else {
                    doubleQuotes = 0;
                    if (c == '\n') {
                        ++currentLineNr;
                        this.append("\\n");
                    } else {
                        this.append(c);
                    }
                }
            } else if (openTree) {
                if (c == '<') {
                    countLesser = (byte)(countLesser + 1);
                    this.append(c);
                    if (countLesser == 4) {
                        openTree = false;
                        treeKeyCombine = false;
                        countLesser = 0;
                    }
                } else {
                    countLesser = 0;
                    if (c == '\n') {
                        ++currentLineNr;
                        if (!treeKeyCombine) {
                            this.append("\\n");
                        }
                        treeKeyCombine = false;
                    } else if (c == ',') {
                        this.append("\\t");
                        treeKeyCombine = true;
                    } else {
                        this.append(c);
                        if (c != ' ') {
                            treeKeyCombine = false;
                        }
                    }
                }
            } else {
                boolean add = true;
                switch (c) {
                    case '\n': {
                        doubleQuotes = 0;
                        commentLine = false;
                        openString = false;
                        openChar = false;
                        openCmd = false;
                        ignoreChar = false;
                        trimLeftSpace = false;
                        lineIndent = 0;
                        if (openTable) {
                            this.append('\u0001');
                        } else {
                            this.add(currentLineNr, filepath);
                            this.currentLine = null;
                        }
                        ++currentLineNr;
                        add = false;
                        break;
                    }
                    case ';': {
                        if (openString || openChar || openCmd) break;
                        this.add(currentLineNr, filepath);
                        this.currentLine = new StringBuilder(Lib_String.sequence('\t', (long)lineIndent));
                        trimLeftSpace = true;
                        add = false;
                        break;
                    }
                    case '\\': {
                        if (!openString && !openChar && !openCmd) break;
                        ignoreChar = true;
                        break;
                    }
                    case '\'': {
                        if (openString || openCmd) break;
                        openChar = !openChar;
                        break;
                    }
                    case '\"': {
                        if (openChar || openCmd) break;
                        openString = !openString;
                        doubleQuotes = (byte)(doubleQuotes + 1);
                        if (openString || doubleQuotes != 4) break;
                        openText = true;
                        doubleQuotes = 0;
                        this.currentLine = new StringBuilder(this.currentLine.substring(0, this.currentLine.length() - 3));
                        break;
                    }
                    case '>': {
                        if (openChar || openCmd || openString || commentLine || commentBlock || (countGreater = (int)((byte)(countGreater + 1))) != 4) break;
                        openTree = true;
                        countGreater = 0;
                        break;
                    }
                    case '|': {
                        if (openChar || openCmd || openString || commentLine || commentBlock || (countPipe = (int)((byte)(countPipe + 1))) != 4) break;
                        openTable = !openTable;
                        countPipe = 0;
                        break;
                    }
                    case '`': 
                    case '\u00b4': {
                        if (!openCmd && last1 == ')' || openChar || openString) break;
                        openCmd = !openCmd;
                        break;
                    }
                    case '#': {
                        if (!commentBlock && last1 == '*' && abortPart == 3) {
                            abort = true;
                            break;
                        }
                        if (openChar || openString || openCmd) break;
                        int n3 = abortPart = commentLine ? 0 : 1;
                        if (commentBlock) break;
                        commentLine = true;
                        add = false;
                        break;
                    }
                    case '*': {
                        if (last1 == '#' && abortPart == 1) {
                            abortPart = 2;
                            break;
                        }
                        if (last1 == '*' && abortPart == 2) {
                            abortPart = 3;
                            break;
                        }
                        if (last1 != 47 || last2 == 47 || commentLine || openString || openChar || openCmd) break;
                        commentBlock = true;
                        add = false;
                        if (this.currentLine == null || this.currentLine.charAt(this.currentLine.length() - 1) != '/') break;
                        this.currentLine = new StringBuilder(this.currentLine.substring(0, this.currentLine.length() - 1));
                        break;
                    }
                    case '/': {
                        if (last1 != 42 || idx + 1 != len && ca[idx + 1] == '/') break;
                        if (commentBlock) {
                            commentBlock = false;
                            add = false;
                            trimLeftSpace = true;
                            break;
                        }
                        if (commentLine || openString || openText) break;
                        throw new CodeError("Invalid end of block comment!", "Missing: /*", new DebugInfo(filepath, currentLineNr));
                    }
                    case ' ': {
                        if (!trimLeftSpace) break;
                        add = false;
                        break;
                    }
                    case '\t': {
                        if (last1 != '\n' && last1 != 9 || (lineIndent = (int)((byte)(lineIndent + 1))) != 127) break;
                        throw new CodeError("Too much indents!", "Line with " + lineIndent + " tabs.", new DebugInfo(filepath, currentLineNr));
                    }
                    default: {
                        if (c == ',' && openTable) {
                            this.append('\u0002');
                            add = false;
                        }
                        if (c == '(' && openCmd && (last1 == '`' || last1 == '\u00b4')) {
                            openCmd = false;
                        }
                        abortPart = 0;
                        doubleQuotes = 0;
                        countGreater = 0;
                        countLesser = 0;
                        countPipe = 0;
                    }
                }
                if (abort) break;
                if (add && !commentLine && !commentBlock) {
                    trimLeftSpace = false;
                    this.append(c);
                }
                last2 = last1;
                last1 = c;
            }
            ++n2;
        }
        this.add(currentLineNr, filepath);
        return new Group2<String[], int[]>(this.lines.toArray((T[])new String[this.lines.size()]), this.lineNr.toArray());
    }

    private void add(int curLineNr, String filepath) {
        if (this.currentLine == null) {
            return;
        }
        String line = this.currentLine.toString();
        if (line.trim().length() > 0) {
            if (line.charAt(0) == ' ') {
                throw new CodeError("Line starts with Space-Char(s)", "Line: " + curLineNr, new DebugInfo(filepath, curLineNr));
            }
            this.lines.add(line);
            this.lineNr.add(curLineNr);
        }
    }

    private void append(char c) {
        if (this.currentLine == null) {
            this.currentLine = new StringBuilder(32);
        }
        this.currentLine.append(c);
    }

    private void append(String s) {
        if (this.currentLine == null) {
            this.currentLine = new StringBuilder(32);
        }
        this.currentLine.append(s);
    }
}

