/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.struct.I_Series;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.error.Err;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.TypeVariable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class Lib_Java {
    public static boolean isAssignable(Class<?> wantedJava, Class<?> testJayMo) {
        if (wantedJava == Object.class || testJayMo == Nil.class || testJayMo == JMo_Java.class || testJayMo == Str.class && wantedJava == String.class) {
            return true;
        }
        if (testJayMo == Int.class) {
            return wantedJava == Integer.TYPE || wantedJava == Integer.class;
        }
        if (testJayMo == JMo_Byte.class) {
            return wantedJava == Byte.TYPE || wantedJava == Byte.class;
        }
        if (testJayMo == JMo_Short.class) {
            return wantedJava == Short.TYPE || wantedJava == Short.class;
        }
        if (testJayMo == JMo_Long.class) {
            return wantedJava == Long.TYPE || wantedJava == Long.class;
        }
        if (testJayMo == JMo_Float.class) {
            return wantedJava == Float.TYPE || wantedJava == Float.class;
        }
        if (testJayMo == JMo_Double.class) {
            return wantedJava == Double.TYPE || wantedJava == Double.class;
        }
        if (testJayMo == Char.class) {
            return wantedJava == Character.TYPE || wantedJava == Character.class || wantedJava == Integer.TYPE;
        }
        if (testJayMo == Bool.class) {
            return wantedJava == Boolean.TYPE || wantedJava == Boolean.class;
        }
        if (testJayMo == JMo_List.class) {
            return wantedJava == String[].class || wantedJava == Object[].class;
        }
        return false;
    }

    public static boolean isSimpleTypeName(String type) {
        return type.length() >= 6 && type.charAt(0) == 'J' && type.charAt(1) == 'a' && type.charAt(2) == 'v' && type.charAt(3) == 'a' && type.charAt(4) == '_' && type.charAt(5) != '{';
    }

    public static I_Object javaToJmo(Object java) {
        if (java == null) {
            return Nil.NIL;
        }
        if (java instanceof I_Object) {
            return (I_Object)java;
        }
        if (java instanceof Boolean) {
            return Bool.getObject((Boolean)java);
        }
        if (java instanceof Byte) {
            return new JMo_Byte((Byte)java);
        }
        if (java instanceof Short) {
            return new JMo_Short((Short)java);
        }
        if (java instanceof Integer) {
            return new Int((Integer)java);
        }
        if (java instanceof Long) {
            return new JMo_Long((Long)java);
        }
        if (java instanceof Float) {
            return new JMo_Float(((Float)java).floatValue());
        }
        if (java instanceof Double) {
            return new JMo_Double((Double)java);
        }
        if (java instanceof Character) {
            return new Char(((Character)java).charValue());
        }
        if (java instanceof String) {
            return new Str((String)java);
        }
        if (java instanceof String[]) {
            SimpleList<I_Object> al = new SimpleList<I_Object>(((String[])java).length);
            String[] stringArray = (String[])java;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                al.add(new Str(s));
                ++n2;
            }
            return new JMo_List(al);
        }
        if (java instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String ds = sdf.format(java);
            return new JMo_Date(new MDate(ds));
        }
        if (java instanceof Collection) {
            Collection source = (Collection)java;
            SimpleList<I_Object> target = new SimpleList<I_Object>(source.size());
            for (Object o : source) {
                target.add(Lib_Java.javaToJmo(o));
            }
            return new JMo_List(target);
        }
        if (java instanceof HashMap) {
            HashMap source = (HashMap)java;
            JMo_Map target = new JMo_Map();
            for (Map.Entry e : source.entrySet()) {
                target.internalAdd(Lib_Java.javaToJmo(e.getKey()), Lib_Java.javaToJmo(e.getValue()));
            }
            return target;
        }
        return new JMo_Java(java);
    }

    public static Object jmoToJava(CallRuntime cr, I_Object jmo, Class<?> wanted) {
        return Lib_Java.jmoToJava(cr, jmo, wanted, true);
    }

    public static Object jmoToJava(CallRuntime cr, I_Object jmo, Class<?> wanted, boolean error) {
        if (jmo == Nil.NIL) {
            return null;
        }
        if (jmo instanceof JMo_Java) {
            return ((JMo_Java)jmo).getJavaObject();
        }
        if (jmo instanceof I_Atomic) {
            return ((I_Atomic)jmo).getValue();
        }
        if (jmo instanceof JMo_List) {
            I_Series source = ((JMo_List)jmo).getInternalCollection();
            return Lib_Java.iListToJava(cr, (List<I_Object>)((Object)source), wanted);
        }
        if (jmo instanceof JMo_Map) {
            HashMap<I_Object, I_Object> source = ((JMo_Map)jmo).copyToHashMap();
            HashMap<Object, Object> target = new HashMap<Object, Object>();
            for (Map.Entry<I_Object, I_Object> e : source.entrySet()) {
                target.put(Lib_Java.jmoToJava(cr, e.getKey(), null, error), Lib_Java.jmoToJava(cr, e.getValue(), null, error));
            }
            return target;
        }
        if (error) {
            throw new RuntimeError(cr, "No Java representation found", "Conversion from <" + jmo.getTypeName() + "> to Java failed.");
        }
        return jmo;
    }

    public static Object[] jmoToJava(CallRuntime cr, I_Object[] args, Parameter[] pars) {
        int len = args.length;
        Object[] result = new Object[len];
        int p = 0;
        while (p < len) {
            result[p] = Lib_Java.jmoToJava(cr, args[p], pars == null ? null : pars[p].getType(), true);
            ++p;
        }
        return result;
    }

    public static ObjectCallResult mExec(CallRuntime cr, Object instance, Class<?> instance_class, String m, I_Object streamIt) {
        String instanceClassName;
        Class<?>[] innerClasses;
        Method[] methods;
        Err.ifNull((Object)streamIt);
        I_Object[] args = cr.argsVar(streamIt, 0, 0);
        int parsLen = args.length;
        Method[] methodArray = methods = instance_class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(m) && method.getParameterCount() == parsLen && Lib_Java.testPars(method.getParameters(), args)) {
                Object[] invokePars = Lib_Java.jmoToJava(cr, args, method.getParameters());
                method.setAccessible(true);
                Object result = null;
                try {
                    result = method.invoke(instance, invokePars);
                }
                catch (NullPointerException e) {
                    return null;
                }
                try {
                    return A_Object.stdResult(Lib_Java.javaToJmo(result));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    String methodString = "Java(\"" + method.getDeclaringClass().getSimpleName() + "\")." + method.getName();
                    String msg = e instanceof IllegalAccessException ? "Illegal access to Java-method" : (e instanceof IllegalArgumentException ? "Illegal argument for Java-method" : "Invocation error");
                    throw new ExternalError(cr, String.valueOf(msg) + ": " + methodString, Lib_Error.collectMessages(e));
                }
            }
            ++n2;
        }
        Class<?>[] invokePars = innerClasses = instance_class.getClasses();
        int n3 = innerClasses.length;
        n = 0;
        while (n < n3) {
            Class<?> cl = invokePars[n];
            if (cl.getSimpleName().equals(m) && cl.getTypeParameters().length == parsLen) {
                if (parsLen != 0) {
                    Lib_Error.notImplementedYet(cr, "Access to inner class with arguments is currently not available!");
                }
                if (Lib_Java.testPars(cl.getTypeParameters(), args)) {
                    JMo_Java result;
                    Call[] cArgs = new Call[args.length];
                    int i = 0;
                    while (i < args.length) {
                        cArgs[i] = new Call(cr, args[i]);
                        ++i;
                    }
                    try {
                        result = null;
                        try {
                            result = new JMo_Java(cl, cArgs, cr.getDebugInfo());
                        }
                        catch (NullPointerException e) {
                            return null;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        String methodString = "Java(\"" + instance_class.getName() + "\")." + cl.getSimpleName();
                        String msg = "Illegal argument for Java-method";
                        throw new ExternalError(cr, "Illegal argument for Java-method: " + methodString, Lib_Error.collectMessages(e));
                    }
                    return A_Object.stdResult(Lib_Java.javaToJmo(result));
                }
            }
            ++n;
        }
        if (instance != null && (instanceClassName = instance.getClass().getName()).charAt(0) == '[') {
            int idx;
            if (m.equals("length")) {
                return A_Object.stdResult(new Int(Array.getLength(instance)));
            }
            if (m.equals("get") && args.length == 1) {
                I_Object paro = cr.argType(args[0], A_IntNumber.class);
                idx = Lib_Convert.getIntValue(cr, paro);
                Object result = Array.get(instance, idx);
                I_Object jmo = Lib_Java.javaToJmo(result);
                return A_Object.stdResult(jmo);
            }
            if (m.equals("set") && args.length == 2) {
                I_Object idxo = cr.argType(args[1], A_IntNumber.class);
                idx = Lib_Convert.getIntValue(cr, idxo);
                I_Object obj = args[0];
                Object javaObject = Lib_Java.jmoToJavaType(cr, instanceClassName.charAt(1), obj);
                Array.set(instance, idx, javaObject);
                return A_Object.stdResult(streamIt);
            }
        }
        try {
            Field f = instance_class.getField(m);
            if (f != null) {
                Object value = f.get(instance);
                I_Object jmoValue = Lib_Java.javaToJmo(value);
                return A_Object.stdResult(jmoValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    public static String packConv_classToFull(Class<?> clazz) {
        String canonical = clazz.getCanonicalName();
        StringBuilder sb = new StringBuilder(32);
        sb.append("Java_{");
        if (canonical == null) {
            sb.append(clazz.getSimpleName());
        } else {
            sb.append(canonical);
        }
        sb.append('}');
        return sb.toString();
    }

    public static String packConv_classToSimple(Class<?> clazz) {
        return "Java_" + clazz.getSimpleName();
    }

    public static String packConv_FullToClass(String full) {
        return full.substring(6, full.length() - 1);
    }

    public static boolean testPar(Parameter parameter, I_Object object) {
        Class<?> pClass = parameter.getType();
        int parModif = parameter.getModifiers();
        Class<?> oClass = object.getClass();
        if (parModif != 0) {
            Err.todo(pClass, parModif, oClass);
        }
        return Lib_Java.isAssignable(pClass, oClass);
    }

    public static boolean testPars(Parameter[] parameters, I_Object[] args) {
        if (parameters.length != args.length) {
            return false;
        }
        int pn = 0;
        while (pn < parameters.length) {
            if (!Lib_Java.testPar(parameters[pn], args[pn])) {
                return false;
            }
            ++pn;
        }
        return true;
    }

    public static Class<?> toJavaType(Object object) {
        if (object == null) {
            return Nil.class;
        }
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        return object.getClass();
    }

    private static Object iListToJava(CallRuntime cr, List<I_Object> source, Class<?> wanted) {
        if (wanted != null) {
            if (wanted == Object[].class) {
                Object[] arr = new Object[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == String[].class) {
                String[] arr = new String[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getStringValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Byte[].class) {
                Byte[] arr = new Byte[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getByteValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == byte[].class) {
                byte[] arr = new byte[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getByteValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Short[].class) {
                Short[] arr = new Short[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getShortValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == short[].class) {
                short[] arr = new short[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getShortValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Integer[].class) {
                Integer[] arr = new Integer[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getIntValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == int[].class) {
                int[] arr = new int[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getIntValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Long[].class) {
                Long[] arr = new Long[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getLongValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == long[].class) {
                long[] arr = new long[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getLongValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Boolean[].class) {
                Boolean[] arr = new Boolean[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getBoolValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == boolean[].class) {
                boolean[] arr = new boolean[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getBoolValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Float[].class) {
                Float[] arr = new Float[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Float.valueOf(Lib_Convert.getFloatValue(cr, source.get(i)));
                    ++i;
                }
                return arr;
            }
            if (wanted == float[].class) {
                float[] arr = new float[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getFloatValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Double[].class) {
                Double[] arr = new Double[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getDoubleValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == double[].class) {
                double[] arr = new double[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getDoubleValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
            if (wanted == Character[].class) {
                Character[] arr = new Character[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Character.valueOf(Lib_Convert.getCharValue(cr, source.get(i)));
                    ++i;
                }
                return arr;
            }
            if (wanted == char[].class) {
                char[] arr = new char[source.size()];
                int i = 0;
                while (i < source.size()) {
                    arr[i] = Lib_Convert.getCharValue(cr, source.get(i));
                    ++i;
                }
                return arr;
            }
        }
        SimpleList<Object> al = new SimpleList<Object>(source.size());
        for (I_Object o : source) {
            al.add(Lib_Java.jmoToJava(cr, o, null, true));
        }
        return al;
    }

    private static Object jmoToJavaType(CallRuntime cr, char type, I_Object obj) {
        Object java = Lib_Java.jmoToJava(cr, obj, null, true);
        if (java instanceof Number) {
            if (type == 'I') {
                return ((Number)java).intValue();
            }
            if (type == 'B') {
                return ((Number)java).byteValue();
            }
            if (type == 'S') {
                return ((Number)java).shortValue();
            }
            if (type == 'L') {
                return ((Number)java).longValue();
            }
            if (type == 'F') {
                return Float.valueOf(((Number)java).floatValue());
            }
            if (type == 'D') {
                return ((Number)java).doubleValue();
            }
        }
        return java;
    }

    private static boolean testPars(TypeVariable<?>[] parameters, I_Object[] args) {
        return parameters.length == args.length;
    }
}

