/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.struct.I_Series;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.data.util.Lib_Array;
import de.mn77.base.error.Err;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Collection;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.I_ObjectToString;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.object.pseudo.MultiCall;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_ConvertExact;
import org.jaymo_lang.util.Lib_Type;

public class Lib_Convert {
    private static final Class<?>[] INT_TO_OBJECT_ARRAY = new Class[]{Bool.class, JMo_Byte.class, JMo_Short.class, Int.class, JMo_Long.class, Char.class};

    public static BigDecimal getBigDecimalValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_BigDec) {
            return ((JMo_BigDec)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return (BigDecimal)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.BIGDEC).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "BigInt");
    }

    public static BigInteger getBigIntegerValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_BigInt) {
            return ((JMo_BigInt)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return (BigInteger)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.BIGINT).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "BigInt");
    }

    public static boolean getBoolValue(CallRuntime cr, I_Object o) {
        if (o instanceof Bool) {
            return ((Bool)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return (Boolean)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.BOOL).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Bool");
    }

    public static byte getByteValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Byte) {
            return ((JMo_Byte)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return (Byte)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.BYTE).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Byte");
    }

    public static char getCharValue(CallRuntime cr, I_Object o) {
        return Lib_Convert.getCharValue(cr, o, false);
    }

    public static char getCharValue(CallRuntime cr, I_Object o, boolean cut) {
        if (o instanceof Char) {
            return ((Char)o).getValue().charValue();
        }
        if (o instanceof Bool) {
            return ((Bool)o).getValue() != false ? (char)'1' : '0';
        }
        if (o instanceof I_Atomic) {
            if (cut) {
                return ((I_Atomic)o).getValue().toString().charAt(0);
            }
            return ((Character)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.CHAR).getValue()).charValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Char");
    }

    public static Dec getDecValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Dec) {
            return ((JMo_Dec)o).getValue();
        }
        if (o instanceof JMo_Byte) {
            return Dec.valueOf(((JMo_Byte)o).getValue());
        }
        if (o instanceof JMo_Short) {
            return Dec.valueOf(((JMo_Short)o).getValue());
        }
        if (o instanceof Int) {
            return Dec.valueOf(((Int)o).getValue());
        }
        if (o instanceof JMo_Long) {
            return Dec.valueOf(((JMo_Long)o).getValue());
        }
        if (o instanceof JMo_Float) {
            return Dec.valueOf(((JMo_Float)o).getValue().floatValue());
        }
        if (o instanceof JMo_Double) {
            return Dec.valueOf(((JMo_Double)o).getValue());
        }
        throw Lib_Convert.iConvertError(cr, o, "Dec");
    }

    public static double getDoubleValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Double) {
            return ((JMo_Double)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return (Double)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.DOUBLE).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Double");
    }

    public static File getFile(CallRuntime cr, I_Object arg) {
        if (arg instanceof JMo_File) {
            return ((JMo_File)arg).getInternalFile();
        }
        if (arg instanceof Str) {
            String value = Lib_Convert.getStringValue(cr, arg);
            return new File(value);
        }
        throw Lib_Convert.iConvertError(cr, arg, "File or Str");
    }

    public static float getFloatValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Float) {
            return ((JMo_Float)o).getValue().floatValue();
        }
        if (o instanceof I_Atomic) {
            return ((Float)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.FLOAT).getValue()).floatValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Float");
    }

    public static int getIntValue(CallRuntime cr, I_Object o) {
        return Lib_Convert.getIntValue(cr, o, false);
    }

    public static int getIntValue(CallRuntime cr, I_Object o, boolean ord) {
        if (o instanceof Int) {
            return ((Int)o).getValue();
        }
        if (ord && o instanceof Char) {
            return ((Char)o).getValue().charValue();
        }
        if (o instanceof I_Atomic) {
            Object to = Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.INT).getValue();
            if (to == null || to == Nil.NIL) {
                throw Lib_Convert.iConvertError(cr, o, "Int");
            }
            return (Integer)to;
        }
        throw Lib_Convert.iConvertError(cr, o, "Int");
    }

    public static long getLongValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Long) {
            return ((JMo_Long)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return (Long)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.LONG).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Long");
    }

    public static short getShortValue(CallRuntime cr, I_Object o) {
        if (o instanceof JMo_Short) {
            return ((JMo_Short)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return (Short)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.SHORT).getValue();
        }
        throw Lib_Convert.iConvertError(cr, o, "Short");
    }

    public static String getStringValue(CallRuntime cr, I_Object o) {
        if (o instanceof Str) {
            return ((Str)o).getValue();
        }
        if (o instanceof I_Atomic) {
            return ((Str)Lib_AtomConv.convert(cr, (I_Atomic)o, ATOMIC.STR)).getValue();
        }
        return o.toString(cr, STYPE.REGULAR);
    }

    public static I_Object getValue(CallRuntime cr, I_Object o) {
        Err.ifNull((Object)o);
        o.initOnce(cr);
        if (o instanceof I_Mem) {
            return ((I_Mem)o).get(cr);
        }
        if (o instanceof MultiCall) {
            return ((MultiCall)o).getCurrent();
        }
        return o;
    }

    public static I_Object intToObject(Class<?> start, Class<?> end, int i) {
        int idxEnd;
        int idxStart = Lib_Array.indexOf(start, INT_TO_OBJECT_ARRAY);
        Class<?> type = INT_TO_OBJECT_ARRAY[Math.max(idxStart, idxEnd = Lib_Array.indexOf(end, INT_TO_OBJECT_ARRAY))];
        if (type == Bool.class) {
            return Bool.getObject(i != 0);
        }
        if (type == JMo_Byte.class) {
            return new JMo_Byte((byte)i);
        }
        if (type == JMo_Short.class) {
            return new JMo_Short((short)i);
        }
        if (type == Int.class) {
            return new Int(i);
        }
        if (type == JMo_Long.class) {
            return new JMo_Long(i);
        }
        if (type == Char.class) {
            return new Char((char)i);
        }
        throw Err.todo(type, i);
    }

    public static I_Object memConvert(CallRuntime cr, String definedType, String objType, I_Object obj) {
        block44: {
            boolean objIsInt;
            block42: {
                boolean objIsDec = obj instanceof I_Decimal;
                if (!objIsDec) break block42;
                switch (definedType) {
                    case "Byte": {
                        return new JMo_Byte(((Number)((A_DecNumber)obj).getValue()).byteValue());
                    }
                    case "Short": {
                        return new JMo_Short(((Number)((A_DecNumber)obj).getValue()).shortValue());
                    }
                    case "Int": {
                        return new Int(((Number)((A_DecNumber)obj).getValue()).intValue());
                    }
                    case "Long": {
                        return new JMo_Long(((Number)((A_DecNumber)obj).getValue()).longValue());
                    }
                    case "BigInt": {
                        return new JMo_BigInt(BigInteger.valueOf(((Number)((A_DecNumber)obj).getValue()).longValue()));
                    }
                    case "Float": {
                        if (!objType.equals("Double")) break;
                        return new JMo_Float(Lib_ConvertExact.doubleToFloat(cr, ((JMo_Double)obj).getValue()));
                    }
                }
            }
            if (!(objIsInt = obj instanceof I_Integer)) break block44;
            switch (definedType) {
                case "Float": {
                    return new JMo_Float(((Number)((A_IntNumber)obj).getValue()).floatValue());
                }
                case "Dec": {
                    return new JMo_Double(((Number)((A_IntNumber)obj).getValue()).doubleValue());
                }
                case "BigDec": {
                    return new JMo_BigDec(BigDecimal.valueOf(((Number)((A_IntNumber)obj).getValue()).doubleValue()));
                }
                case "Byte": {
                    if (objType.equals("Int")) {
                        return new JMo_Byte(Lib_ConvertExact.intToByte(cr, ((Int)obj).getValue()));
                    }
                }
                case "Short": {
                    if (!objType.equals("Int")) break;
                    return new JMo_Short(Lib_ConvertExact.intToShort(cr, ((Int)obj).getValue()));
                }
            }
        }
        return obj;
    }

    public static I_Object toJMo(CallRuntime cr, Object o, boolean strict) {
        if (o == null) {
            return Nil.NIL;
        }
        Class<?> cls = o.getClass();
        if (cls == String.class) {
            return new Str((String)o);
        }
        if (cls == Boolean.class) {
            return (Boolean)o != false ? Bool.TRUE : Bool.FALSE;
        }
        if (cls == Character.class) {
            return new Char(((Character)o).charValue());
        }
        if (cls == Byte.class) {
            return new JMo_Byte((Byte)o);
        }
        if (cls == Short.class) {
            return new JMo_Short((Short)o);
        }
        if (cls == Integer.class) {
            return new Int((Integer)o);
        }
        if (cls == Long.class) {
            return new JMo_Long((Long)o);
        }
        if (cls == Float.class) {
            return new JMo_Float(((Float)o).floatValue());
        }
        if (cls == Double.class) {
            return new JMo_Double((Double)o);
        }
        if (cls == Date.class) {
            return new JMo_Date(new MDate((Date)o));
        }
        if (cls == Time.class) {
            return new JMo_Time(new MTime((Time)o));
        }
        if (!strict) {
            try {
                if (cls == BigDecimal.class) {
                    return new JMo_Double(((BigDecimal)o).doubleValue());
                }
                if (cls == BigInteger.class) {
                    return new Int(((BigInteger)o).intValueExact());
                }
            }
            catch (ArithmeticException e) {
                throw new RuntimeError(cr, "Value out of bounds", e.getMessage());
            }
        }
        return new JMo_Java(o);
    }

    public static JMo_List toJMo(Collection<String> list) {
        Err.ifNull(list);
        SimpleList<I_Object> al = new SimpleList<I_Object>(list.size());
        for (String s : list) {
            if (s == null) {
                al.add(Nil.NIL);
                continue;
            }
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }

    public static JMo_Table toJMo(I_Table<String> tab) {
        Err.ifNull(tab);
        ArrayTable<I_Object> result = new ArrayTable<I_Object>(tab.width());
        for (String[] stringArray : tab) {
            result.add((T[])Lib_Convert.toJMoArray(stringArray));
        }
        return new JMo_Table(result);
    }

    public static JMo_List toJMo(String[] list) {
        Err.ifNull((Object)list);
        SimpleList<I_Object> al = new SimpleList<I_Object>(list.length);
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s == null) {
                al.add(Nil.NIL);
            } else {
                al.add(new Str(s));
            }
            ++n2;
        }
        return new JMo_List(al);
    }

    public static I_Object[] toJMoArray(String[] list) {
        Err.ifNull((Object)list);
        I_Object[] result = new I_Object[list.length];
        int i = 0;
        while (i < list.length) {
            String item = list[i];
            result[i] = item == null ? Nil.NIL : new Str(item);
            ++i;
        }
        return result;
    }

    public static SimpleList<String> toListString(Collection<I_Object> list) {
        Err.ifNull(list);
        SimpleList<String> res = new SimpleList<String>(list.size());
        for (I_Object s : list) {
            res.add(Lib_Convert.getStringValue(null, s));
        }
        return res;
    }

    public static I_Object toSafeType(CallRuntime cr, I_Atomic arg, String typeName) {
        switch (arg.getEnum()) {
            case BYTE: {
                switch (typeName) {
                    case "Short": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.SHORT);
                    }
                    case "Int": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.INT);
                    }
                    case "Long": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.LONG);
                    }
                    case "BigInt": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGINT);
                    }
                    case "Dec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.DEC);
                    }
                    case "Float": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.FLOAT);
                    }
                    case "Double": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.DOUBLE);
                    }
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case SHORT: {
                switch (typeName) {
                    case "Int": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.INT);
                    }
                    case "Long": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.LONG);
                    }
                    case "BigInt": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGINT);
                    }
                    case "Dec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.DEC);
                    }
                    case "Float": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.FLOAT);
                    }
                    case "Double": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.DOUBLE);
                    }
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case INT: {
                switch (typeName) {
                    case "Long": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.LONG);
                    }
                    case "BigInt": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGINT);
                    }
                    case "Dec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.DEC);
                    }
                    case "Double": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.DOUBLE);
                    }
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case LONG: {
                switch (typeName) {
                    case "BigInt": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGINT);
                    }
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case BIGINT: {
                switch (typeName) {
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case DEC: {
                switch (typeName) {
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case FLOAT: {
                switch (typeName) {
                    case "Double": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.DOUBLE);
                    }
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case DOUBLE: {
                switch (typeName) {
                    case "BigDec": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.BIGDEC);
                    }
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case BIGDEC: {
                switch (typeName) {
                    case "Str": {
                        return Lib_AtomConv.convert(cr, arg, ATOMIC.STR);
                    }
                }
                return arg;
            }
            case CHAR: {
                return typeName.equals("Str") ? Lib_AtomConv.convert(cr, arg, ATOMIC.STR) : arg;
            }
        }
        return arg;
    }

    public static String toString(Call c) {
        if (c == null) {
            return Nil.NIL.toString();
        }
        return c.toString();
    }

    public static String toString(CallRuntime cr, boolean nested, String delimiter, I_ObjectToString[] arr) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arr.length) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(arr[i].toString(cr, nested ? STYPE.NESTED : STYPE.REGULAR));
            ++i;
        }
        return sb.toString();
    }

    public static String[] toStringArray(I_Object[] titles) {
        Err.ifNull((Object)titles);
        int len = titles.length;
        String[] result = new String[len];
        int i = 0;
        while (i < len) {
            result[i] = Lib_Convert.getStringValue(null, titles[i]);
            ++i;
        }
        return result;
    }

    public static String[] toStringArray(JMo_List targetArgs) {
        Err.ifNull((Object)targetArgs);
        I_Series internalList = targetArgs.getInternalCollection();
        int len = ((SimpleList)internalList).size();
        String[] result = new String[len];
        int i = 0;
        while (i < len) {
            result[i] = Lib_Convert.getStringValue(null, (I_Object)((SimpleList)internalList).get(i));
            ++i;
        }
        return result;
    }

    public static ArrayTable<String> toTableString(JMo_Table tab) {
        ArrayTable<String> res = new ArrayTable<String>(tab.getInternalObject().width());
        for (I_Object[] i_ObjectArray : tab.getInternalObject()) {
            res.add((T[])Lib_Convert.toStringArray(i_ObjectArray));
        }
        return res;
    }

    public static String typelistToText(Class<?>[] types) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int pos = 0;
        while (pos < types.length) {
            Class<?> c = types[pos];
            if (pos != 0) {
                sb.append(", ");
            }
            sb.append(Lib_Type.getName(c, null));
            ++pos;
        }
        sb.append(")");
        return sb.toString();
    }

    private static RuntimeError iConvertError(CallRuntime cr, I_Object o, String neededType) {
        return new RuntimeError(cr, "Invalid type", "Object cannot be converted to " + neededType + ". Got: " + o.toString(cr, STYPE.IDENT));
    }
}

