/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.parser.PARSER_LEVEL;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.parser.obj.ParseObj_Bin;
import org.jaymo_lang.parser.obj.ParseObj_Char;
import org.jaymo_lang.parser.obj.ParseObj_Const;
import org.jaymo_lang.parser.obj.ParseObj_Help;
import org.jaymo_lang.parser.obj.ParseObj_Hex;
import org.jaymo_lang.parser.obj.ParseObj_MagicConst;
import org.jaymo_lang.parser.obj.ParseObj_MagicVar;
import org.jaymo_lang.parser.obj.ParseObj_MagicVar_Shortcut;
import org.jaymo_lang.parser.obj.ParseObj_MemLet;
import org.jaymo_lang.parser.obj.ParseObj_NewWithArg;
import org.jaymo_lang.parser.obj.ParseObj_NewWithOpenArg;
import org.jaymo_lang.parser.obj.ParseObj_NewWithoutArg;
import org.jaymo_lang.parser.obj.ParseObj_Number;
import org.jaymo_lang.parser.obj.ParseObj_Oct;
import org.jaymo_lang.parser.obj.ParseObj_ShortCuts;
import org.jaymo_lang.parser.obj.ParseObj_Stream;
import org.jaymo_lang.parser.obj.ParseObj_String;
import org.jaymo_lang.parser.obj.ParseObj_SysCom;
import org.jaymo_lang.parser.obj.ParseObj_Table;
import org.jaymo_lang.parser.obj.ParseObj_Tree;
import org.jaymo_lang.parser.obj.ParseObj_Type;
import org.jaymo_lang.parser.obj.ParseObj_Var;
import org.jaymo_lang.parser.obj.ParseObj_VarConstType;

public class ParseManagerObj {
    private static final ParseObj_VarConstType parser_varConstType = new ParseObj_VarConstType();
    private static final ParseObj_MagicVar parser_magicVar = new ParseObj_MagicVar();
    private static final ParseObj_Bin parser_bin = new ParseObj_Bin();
    private static final ParseObj_Hex parser_hex = new ParseObj_Hex();
    private static final ParseObj_Oct parser_oct = new ParseObj_Oct();
    private static final ParseObj_Number parser_number = new ParseObj_Number();
    private static final ParseObj_Char parser_char = new ParseObj_Char();
    private static final ParseObj_String parser_string = new ParseObj_String();
    private static final ParseObj_Type parser_type = new ParseObj_Type();
    private static final ParseObj_SysCom parser_syscom = new ParseObj_SysCom();
    private static final ParseObj_Stream parser_stream = new ParseObj_Stream();
    private static final ParseObj_MagicVar_Shortcut parser_magicVarShortcut = new ParseObj_MagicVar_Shortcut();
    private static final ParseObj_Var parser_var = new ParseObj_Var();
    private static final ParseObj_MemLet parser_memlet = new ParseObj_MemLet();
    private static final ParseObj_MagicConst parser_magicConst = new ParseObj_MagicConst();
    private static final ParseObj_Const parser_const = new ParseObj_Const();
    private static final ParseObj_NewWithArg parser_newWithArg = new ParseObj_NewWithArg();
    private static final ParseObj_NewWithOpenArg parser_newWithOpenArg = new ParseObj_NewWithOpenArg();
    private static final ParseObj_NewWithoutArg parser_newWithoutArg = new ParseObj_NewWithoutArg();
    private static final ParseObj_Table parser_table = new ParseObj_Table();
    private static final ParseObj_Tree parser_tree = new ParseObj_Tree();
    private static final ParseObj_Help parser_help = new ParseObj_Help();
    private final ParseObj_ShortCuts parser_shortcuts = new ParseObj_ShortCuts();
    private boolean shortCuts = true;
    private boolean sysCom = true;
    private boolean magicShortCuts = true;

    public I_ParseObject getParser(Block current, String s, Parser_Script parser, boolean isArgument) {
        char c0 = s.charAt(0);
        I_ParseObject po = this.iGetParser(c0, current, s);
        if (po != null) {
            if (isArgument) {
                if (po == parser_stream) {
                    throw new CodeError("Unknown object as argument for function", "Arguments can't start with a dot, but got: " + s, parser);
                }
                if (po == parser_newWithOpenArg) {
                    throw new CodeError("Invalid use of open argument", "Please use brackets for nested argument: " + s, parser);
                }
            }
            return po;
        }
        throw new CodeError("Unknown object", s, parser);
    }

    public void strictLevel(PARSER_LEVEL level) {
        this.parser_shortcuts.strict(level.isAllowed(PARSER_LEVEL.INSANE), level.isAllowed(PARSER_LEVEL.HIGH), level.isAllowed(PARSER_LEVEL.LOW));
        this.shortCuts = true;
        this.sysCom = true;
        this.magicShortCuts = true;
        switch (level) {
            case INSANE: {
                this.shortCuts = false;
            }
            case HIGH: {
                this.sysCom = false;
            }
            case MEDIUM: {
                this.magicShortCuts = false;
            }
        }
    }

    public void strictSandbox() {
        this.sysCom = false;
    }

    private I_ParseObject iGetParser(char c0, Block current, String s) {
        I_ParseObject po = this.iGetParser1(c0, current, s);
        if (po != null) {
            return po;
        }
        return this.iGetParserX(c0, current, s);
    }

    private I_ParseObject iGetParser1(char c0, Block current, String s) {
        switch (c0) {
            case '.': {
                return parser_stream;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return parser_number;
            }
            case '\"': {
                return parser_string;
            }
            case '\'': {
                return parser_char;
            }
            case '(': 
            case '[': 
            case '{': {
                return this.shortCuts ? this.parser_shortcuts : null;
            }
            case '<': {
                return parser_type;
            }
            case '`': 
            case '\u00b4': {
                return this.sysCom ? parser_syscom : null;
            }
            case '\u00a7': 
            case '\u00b0': {
                return this.magicShortCuts ? parser_magicVarShortcut : null;
            }
            case ':': {
                return parser_memlet;
            }
            case '>': {
                return parser_tree;
            }
            case '|': {
                return parser_table;
            }
            case '?': {
                return parser_help;
            }
        }
        return null;
    }

    private I_ParseObject iGetParserX(char c0, Block current, String s) {
        if (c0 == '0') {
            if (parser_bin.hits(c0, current, s)) {
                return parser_bin;
            }
            if (parser_oct.hits(c0, current, s)) {
                return parser_oct;
            }
            if (parser_hex.hits(c0, current, s)) {
                return parser_hex;
            }
            if (parser_number.hits(c0, current, s)) {
                return parser_number;
            }
            return null;
        }
        if (c0 == '_') {
            if (parser_varConstType.hits(c0, current, s)) {
                return parser_varConstType;
            }
            if (parser_magicConst.hits(c0, current, s)) {
                return parser_magicConst;
            }
            if (parser_newWithArg.hits(c0, current, s)) {
                return parser_newWithArg;
            }
            if (parser_newWithOpenArg.hits(c0, current, s)) {
                return parser_newWithOpenArg;
            }
            if (parser_newWithoutArg.hits(c0, current, s)) {
                return parser_newWithoutArg;
            }
            return null;
        }
        if (c0 == '-' || c0 == '+') {
            if (parser_magicVar.hits(c0, current, s)) {
                return parser_magicVar;
            }
            if (parser_number.hits(c0, current, s)) {
                return parser_number;
            }
            return null;
        }
        if (c0 >= 'A' && c0 <= 'Z') {
            if (parser_magicVar.hits(c0, current, s)) {
                return parser_magicVar;
            }
            if (parser_varConstType.hits(c0, current, s)) {
                return parser_varConstType;
            }
            if (parser_const.hits(c0, current, s)) {
                return parser_const;
            }
            if (parser_newWithArg.hits(c0, current, s)) {
                return parser_newWithArg;
            }
            if (parser_newWithOpenArg.hits(c0, current, s)) {
                return parser_newWithOpenArg;
            }
            if (parser_newWithoutArg.hits(c0, current, s)) {
                return parser_newWithoutArg;
            }
            return null;
        }
        if (c0 >= 'a' && c0 <= 'z') {
            if (parser_magicVar.hits(c0, current, s)) {
                return parser_magicVar;
            }
            if (parser_var.hits(c0, current, s)) {
                return parser_var;
            }
        }
        return null;
    }
}

