/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute.datetime;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.datetime.A_DateTimeBase;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_DateTime;
import org.jaymo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Time
extends A_DateTimeBase {
    private I_Time time = null;
    private final ArgCallBuffer[] init;

    public JMo_Time() {
        this.init = null;
    }

    public JMo_Time(Call arg) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, arg)};
    }

    public JMo_Time(Call h, Call m) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, h), new ArgCallBuffer(1, m)};
    }

    public JMo_Time(Call h, Call m, Call s) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, h), new ArgCallBuffer(1, m), new ArgCallBuffer(2, s)};
    }

    public JMo_Time(Call h, Call m, Call s, Call ms) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, h), new ArgCallBuffer(1, m), new ArgCallBuffer(2, s), new ArgCallBuffer(3, ms)};
    }

    public JMo_Time(I_Time time) {
        this.init = null;
        this.time = time;
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_Time ? this.time.isEqual(((JMo_Time)arg).getInternalTime()) : false;
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            String s = ((Str)other).getValue();
            switch (s.length()) {
                case 8: {
                    return s.equals(this.time.toStringShort());
                }
                case 12: {
                    return s.equals(this.time.toString());
                }
            }
            return false;
        }
        return this.equals(other);
    }

    @Override
    public void init(CallRuntime cr) {
        block12: {
            if (this.time != null) {
                return;
            }
            if (this.init == null) {
                this.time = new MTime();
                return;
            }
            String errPars = "";
            int initLen = this.init.length;
            try {
                if (initLen == 1) {
                    String s;
                    I_Object o = this.init[0].initExt(cr, this, A_IntNumber.class, Str.class);
                    if (o instanceof A_IntNumber) {
                        int ms = Lib_Convert.getIntValue(cr, o);
                        errPars = "" + ms;
                        this.time = new MTime(ms);
                        break block12;
                    }
                    errPars = s = Lib_Convert.getStringValue(cr, o);
                    try {
                        this.time = new MTime(s);
                        break block12;
                    }
                    catch (Err_Runtime err) {
                        throw new RuntimeError(cr, "Invalid argument for <Time>", "Parse error! Got: Time(\"" + s + "\")");
                    }
                }
                if (initLen == 2) {
                    int ih = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, A_IntNumber.class));
                    int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, A_IntNumber.class));
                    errPars = String.valueOf(ih) + "," + im;
                    this.time = new MTime(ih, im, 0);
                } else if (initLen == 3) {
                    int ih = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, A_IntNumber.class));
                    int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, A_IntNumber.class));
                    int is = Lib_Convert.getIntValue(cr, this.init[2].init(cr, this, A_IntNumber.class));
                    errPars = String.valueOf(ih) + "," + im + "," + is;
                    this.time = new MTime(ih, im, is);
                } else {
                    int ih = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, A_IntNumber.class));
                    int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, A_IntNumber.class));
                    int is = Lib_Convert.getIntValue(cr, this.init[2].init(cr, this, A_IntNumber.class));
                    int id = Lib_Convert.getIntValue(cr, this.init[3].init(cr, this, A_IntNumber.class));
                    errPars = String.valueOf(ih) + "," + im + "," + is + "," + id;
                    this.time = new MTime(ih, im, is, id);
                }
            }
            catch (Err_Runtime err) {
                throw new RuntimeError(cr, "Invalid time: " + ConvertSequence.toString(", ", err.getDetails()), "Time(" + errPars + ")");
            }
        }
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (this.time == null) {
            return Lib_Type.getName(this);
        }
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.time.toStringShort();
            }
        }
        return String.valueOf(Lib_Type.getName(this)) + "(\"" + this.time.toString() + "\")";
    }

    @Override
    public String toStringFull() {
        if (this.time == null) {
            return Lib_Type.getName(this);
        }
        return this.time.toString();
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getHour": 
            case "getHours": {
                return A_Object.stdResult(this.mGetHours(cr));
            }
            case "getMin": 
            case "getMinutes": {
                return A_Object.stdResult(this.mGetMinutes(cr));
            }
            case "getSeconds": 
            case "getSec": {
                return A_Object.stdResult(this.mGetSeconds(cr));
            }
            case "getMilliSeconds": 
            case "getMSec": {
                return A_Object.stdResult(this.mGetMilliSeconds(cr));
            }
            case "addMSec": 
            case "addMilliSeconds": {
                return A_Object.stdResult(this.mAddSubMilliSeconds(cr, true));
            }
            case "addSec": 
            case "addSeconds": {
                return A_Object.stdResult(this.mAddSubSeconds(cr, true));
            }
            case "addMin": 
            case "addMinutes": {
                return A_Object.stdResult(this.mAddSubMinutes(cr, true));
            }
            case "addHours": {
                return A_Object.stdResult(this.mAddSubHours(cr, true));
            }
            case "addTime": {
                return A_Object.stdResult(this.mAddSubTime(cr, true));
            }
            case "subMSec": 
            case "subMilliSeconds": {
                return A_Object.stdResult(this.mAddSubMilliSeconds(cr, false));
            }
            case "subSec": 
            case "subSeconds": {
                return A_Object.stdResult(this.mAddSubSeconds(cr, false));
            }
            case "subMin": 
            case "subMinutes": {
                return A_Object.stdResult(this.mAddSubMinutes(cr, false));
            }
            case "subHours": {
                return A_Object.stdResult(this.mAddSubHours(cr, false));
            }
            case "subTime": {
                return A_Object.stdResult(this.mAddSubTime(cr, false));
            }
            case "setHours": 
            case "setHour": {
                return A_Object.stdResult(this.mSetHour(cr));
            }
            case "setMinutes": 
            case "setMinute": {
                return A_Object.stdResult(this.mSetMinute(cr));
            }
            case "setSecond": 
            case "setSeconds": {
                return A_Object.stdResult(this.mSetSecond(cr));
            }
            case "setMilliSeconds": 
            case "setMSec": {
                return A_Object.stdResult(this.mSetMilliSeconds(cr));
            }
            case "combine": {
                return A_Object.stdResult(this.mCombine(cr));
            }
            case "diffHours": {
                return A_Object.stdResult(this.mDiffHours(cr));
            }
            case "diffMinutes": {
                return A_Object.stdResult(this.mDiffMinutes(cr));
            }
            case "diffSeconds": 
            case "diff": {
                return A_Object.stdResult(this.mDiffSeconds(cr));
            }
        }
        return null;
    }

    @Override
    protected I_Date getInternalDate() {
        return null;
    }

    @Override
    protected I_Time getInternalTime() {
        return this.time;
    }

    @Override
    protected JMo_Time incdec2(boolean inc, int amount) {
        if (inc) {
            I_Time date2 = this.time.getAddSeconds(amount);
            return new JMo_Time(date2);
        }
        I_Time date2 = this.time.getAddSeconds(-amount);
        return new JMo_Time(date2);
    }

    @Override
    protected boolean[] mCompare2(CallRuntime cr) {
        JMo_Time other = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        boolean isEqual = this.time.isEqual(other.getInternalValue());
        boolean isGreater = this.time.isGreater(other.getInternalValue());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    protected JMo_Time mLimit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_Time.class, JMo_Time.class);
        I_Time min = ((JMo_Time)args[0]).time;
        I_Time max = ((JMo_Time)args[1]).time;
        if (this.time.isGreater(max)) {
            return (JMo_Time)args[1];
        }
        if (min.isGreater(this.time)) {
            return (JMo_Time)args[0];
        }
        return this;
    }

    @Override
    protected I_Object mStyle(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.argsNone();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "i:mm:ss p", this.getInternalDate(), this.getInternalTime());
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    @Override
    protected I_Object pAddSub(CallRuntime cr, A_Number arg, boolean add) {
        double d = Lib_Convert.getDoubleValue(cr, arg);
        if (!add) {
            d = -d;
        }
        int ms = (int)(d * 1000.0);
        I_Time date2 = this.time.getAddMilliSeconds(ms);
        return new JMo_Time(date2);
    }

    @Override
    protected JMo_Long pToMilliSeconds() {
        return new JMo_Long(this.time.getValueMilliSeconds());
    }

    private I_Time getInternalValue() {
        return this.time;
    }

    private JMo_Time mAddSubHours(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddHours(pari);
        return new JMo_Time(date2);
    }

    private JMo_Time mAddSubMilliSeconds(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddMilliSeconds(pari);
        return new JMo_Time(date2);
    }

    private JMo_Time mAddSubMinutes(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddMinutes(pari);
        return new JMo_Time(date2);
    }

    private I_Object mAddSubSeconds(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddSeconds(pari);
        return new JMo_Time(date2);
    }

    private I_Object mAddSubTime(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, JMo_Time.class)[0];
        I_Time part = ((JMo_Time)arg).getInternalTime();
        I_Time temp = this.time;
        temp = temp.getAddHours(add ? part.getHours() : -part.getHours());
        temp = temp.getAddMinutes(add ? part.getMinutes() : -part.getMinutes());
        temp = temp.getAddSeconds(add ? part.getSeconds() : -part.getSeconds());
        temp = temp.getAddMilliSeconds(add ? part.getMilliSeconds() : -part.getMilliSeconds());
        return new JMo_Time(temp);
    }

    private I_Object mCombine(CallRuntime cr) {
        I_Object arg = cr.args(this, JMo_Date.class)[0];
        MDateTime dt = new MDateTime(((JMo_Date)arg).getInternalDate(), this.time);
        return new JMo_DateTime(dt);
    }

    private Int mDiffHours(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffHours(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mDiffMinutes(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffMinutes(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mDiffSeconds(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffSeconds(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mGetHours(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.time.getHours());
    }

    private Int mGetMilliSeconds(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.time.getMilliSeconds());
    }

    private Int mGetMinutes(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.time.getMinutes());
    }

    private Int mGetSeconds(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.time.getSeconds());
    }

    private JMo_Time mSetHour(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetHour(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time mSetMilliSeconds(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetMilliSecond(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time mSetMinute(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetMinute(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time mSetSecond(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetSecond(pari);
        return new JMo_Time(time2);
    }
}

