/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.convert.ConvertSequence;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.math.BigDecimal;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicMath;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Dec
extends A_DecNumber
implements I_Decimal,
I_Atomic {
    public static final BigDecimal TOP_VALUE = new BigDecimal("18446744073.709551615");
    private final Dec value;

    public static JMo_Dec valueOf(CallRuntime cr, double d) {
        if (Double.isFinite(d)) {
            try {
                return new JMo_Dec(Dec.valueOf(d));
            }
            catch (Err_Runtime e) {
                throw new RuntimeError(cr, e.getMessage(), ConvertSequence.toString(", ", e.getDetails()));
            }
        }
        if (Double.isNaN(d)) {
            return new JMo_Dec(Dec.ZERO);
        }
        throw new RuntimeError(cr, "Value out of bounds", "Got: " + (d == Double.POSITIVE_INFINITY ? "infinity" : "-infinity"));
    }

    public JMo_Dec(Dec val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.DEC;
    }

    @Override
    public Dec getValue() {
        return this.value;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        String s = this.value.toString();
        return type == STYPE.DESCRIBE ? String.valueOf(s) + 'c' : s;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return new JMo_Dec(Dec.MAX_VALUE);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new JMo_Dec(Dec.MIN_VALUE);
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_Dec(this.value.neg());
            }
            case ABS: {
                return new JMo_Dec(this.value.abs());
            }
            case EXP: {
                return new JMo_Dec(this.value.exp());
            }
            case INC: {
                return new JMo_Dec(this.value.inc());
            }
            case DEC: {
                return new JMo_Dec(this.value.dec());
            }
            case POW: {
                return new JMo_Dec(this.value.pow());
            }
            case ROOT: {
                return new JMo_Dec(this.value.root());
            }
            case LOG10: {
                return new JMo_Dec(this.value.log10());
            }
            case LOGN: {
                return new JMo_Dec(this.value.logN());
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number arg) {
        if (arg instanceof I_BigNumber) {
            return Lib_AtomicMath.calcBigDec(cr, op, BigDecimal.valueOf(this.value.doubleValue()), Lib_Convert.getBigDecimalValue(cr, arg));
        }
        if (arg instanceof JMo_Long || arg instanceof JMo_Float || arg instanceof JMo_Double) {
            return Lib_AtomicMath.calcDouble(cr, op, this.value.doubleValue(), Lib_Convert.getDoubleValue(cr, arg));
        }
        return Lib_AtomicMath.calcDec(cr, op, this.value, Lib_Convert.getDecValue(cr, arg));
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        Dec arg = Lib_Convert.getDecValue(cr, num);
        return new JMo_Dec(inc ? this.value.add(arg) : this.value.sub(arg));
    }
}

