/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.bigcalc.Lib_BigCalc;
import de.mn77.base.data.util.Lib_BigMath;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicMath;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;

public class JMo_BigInt
extends A_IntNumber
implements I_Integer,
I_Atomic,
I_BigNumber {
    private final BigInteger value;

    public JMo_BigInt(BigInteger val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.BIGINT;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return Lib_BigMath.convertToInt(this.value);
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        boolean addSuffix;
        String result = "" + this.value;
        boolean useNotationE = type != STYPE.DESCRIBE;
        boolean bl = addSuffix = type == STYPE.IDENT || type == STYPE.DESCRIBE;
        if (useNotationE && result.length() > 40) {
            result = Lib_BigMath.toNotationE(result, 16);
        }
        if (addSuffix) {
            result = String.valueOf(result) + 'a';
        }
        return result;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        throw this.newErrorMinMaxValue(cr);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        throw this.newErrorMinMaxValue(cr);
    }

    @Override
    protected final ObjectCallResult mTimes(CallRuntime crOld, boolean reverse) {
        crOld.argsNone();
        Lib_Exec.checkLoopWithout(crOld);
        BigInteger value = this.getValue();
        LoopHandle handle = new LoopHandle(this, reverse ? "timesDown" : "timesUp");
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        if (reverse) {
            BigInteger i = value;
            while (i.compareTo(BigInteger.valueOf(1L)) >= 0) {
                handle.startLap();
                result = Lib_Exec.execBlockStream(crNew, new JMo_BigInt(i));
                result = Lib_Exec.loopResult(result);
                if (result instanceof Return) {
                    return ((Return)result).getLoopResult();
                }
                i = i.subtract(BigInteger.valueOf(1L));
            }
        } else {
            BigInteger i = BigInteger.valueOf(1L);
            while (i.compareTo(value) <= 0) {
                handle.startLap();
                result = Lib_Exec.execBlockStream(crNew, new JMo_BigInt(i));
                result = Lib_Exec.loopResult(result);
                if (result instanceof Return) {
                    return ((Return)result).getLoopResult();
                }
                i = i.add(BigInteger.valueOf(1L));
            }
        }
        return new ObjectCallResult(result, true);
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_BigInt(this.value.negate());
            }
            case ABS: {
                return new JMo_BigInt(this.value.abs());
            }
            case EXP: {
                return new JMo_BigDec(Lib_BigCalc.exp(new BigDecimal(this.value), JMo_BigDec.CONTEXT));
            }
            case INC: {
                return new JMo_BigInt(this.value.add(BigInteger.ONE));
            }
            case DEC: {
                return new JMo_BigInt(this.value.subtract(BigInteger.ONE));
            }
            case POW: {
                return new JMo_BigInt(this.value.multiply(this.value));
            }
            case ROOT: {
                return new JMo_BigDec(new BigDecimal(this.value).sqrt(JMo_BigDec.CONTEXT));
            }
            case LOG10: {
                return new JMo_BigDec(Lib_BigMath.log(new BigDecimal(this.value), BigDecimal.valueOf(10L), JMo_BigDec.CONTEXT));
            }
            case LOGN: {
                return new JMo_BigDec(Lib_BigMath.log(new BigDecimal(this.value), Lib_BigMath.EULER_256, JMo_BigDec.CONTEXT));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number arg) {
        if (arg instanceof I_Integer) {
            return Lib_AtomicMath.calcBigInt(cr, op, this.value, Lib_Convert.getBigIntegerValue(cr, arg));
        }
        return Lib_AtomicMath.calcBigDec(cr, op, new BigDecimal(this.value), Lib_Convert.getBigDecimalValue(cr, arg));
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        BigInteger arg = Lib_Convert.getBigIntegerValue(cr, num);
        return new JMo_BigInt(inc ? this.value.add(arg) : this.value.subtract(arg));
    }

    @Override
    protected JMo_ByteArray toByteArray(CallRuntime cr) {
        byte[] bytes = this.value.toByteArray();
        return new JMo_ByteArray(bytes);
    }
}

