/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.bigcalc.Lib_BigCalc;
import de.mn77.base.data.util.Lib_BigMath;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicMath;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_BigDec
extends A_DecNumber
implements I_Decimal,
I_Atomic,
I_BigNumber {
    public static final MathContext CONTEXT = Lib_BigMath.CONTEXT256;
    public static final MathContext CONTEXT_UP = new MathContext(CONTEXT.getPrecision(), RoundingMode.UP);
    public static final MathContext CONTEXT_DOWN = new MathContext(CONTEXT.getPrecision(), RoundingMode.DOWN);
    public static final MathContext CONTEXT1 = CONTEXT_UP;
    public static final MathContext CONTEXT2 = CONTEXT_UP;
    public static final MathContext CONTEXT3 = CONTEXT;
    private final BigDecimal value;

    public JMo_BigDec(BigDecimal val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.BIGDEC;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        boolean suffix;
        boolean useNotationE = type != STYPE.DESCRIBE;
        boolean bl = suffix = type == STYPE.IDENT || type == STYPE.DESCRIBE;
        if (Double.isNaN(this.value.doubleValue())) {
            return "not_a_number";
        }
        if (this.value.doubleValue() == Double.POSITIVE_INFINITY) {
            return "+infinity";
        }
        if (this.value.doubleValue() == Double.NEGATIVE_INFINITY) {
            return "-infinity";
        }
        String result = this.value.toPlainString();
        if (result.indexOf(46) == -1) {
            result = String.valueOf(result) + ".";
        } else {
            int end = result.length();
            while (result.charAt(end - 1) == '0') {
                --end;
            }
            if (end != result.length()) {
                result = result.substring(0, end);
            }
        }
        if (result.charAt(result.length() - 1) == '.') {
            result = String.valueOf(result) + "0";
        }
        if (useNotationE && result.length() > 40) {
            result = Lib_BigMath.toNotationE(result, 16);
        }
        return suffix ? String.valueOf(result) + 'z' : result;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        throw this.newErrorMinMaxValue(cr);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        throw this.newErrorMinMaxValue(cr);
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_BigDec(this.value.negate());
            }
            case ABS: {
                return new JMo_BigDec(this.value.abs());
            }
            case EXP: {
                return new JMo_BigDec(Lib_BigCalc.exp(this.value, CONTEXT));
            }
            case INC: {
                return new JMo_BigDec(this.value.add(BigDecimal.ONE, CONTEXT));
            }
            case DEC: {
                return new JMo_BigDec(this.value.subtract(BigDecimal.ONE, CONTEXT));
            }
            case POW: {
                return new JMo_BigDec(this.value.multiply(this.value, CONTEXT));
            }
            case ROOT: {
                return new JMo_BigDec(this.value.sqrt(CONTEXT));
            }
            case LOG10: {
                return new JMo_BigDec(Lib_BigMath.log(this.value, BigDecimal.valueOf(10L), CONTEXT));
            }
            case LOGN: {
                return new JMo_BigDec(Lib_BigMath.log(this.value, Lib_BigMath.EULER_256, CONTEXT));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number arg) {
        return Lib_AtomicMath.calcBigDec(cr, op, this.value, Lib_Convert.getBigDecimalValue(cr, arg));
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        BigDecimal arg = Lib_Convert.getBigDecimalValue(cr, num);
        return new JMo_BigDec(inc ? this.value.add(arg, CONTEXT) : this.value.subtract(arg, CONTEXT));
    }
}

