/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.I_AutoBlockList;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_ControlObject;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Dec;
import org.jaymo_lang.object.atom.JMo_Double;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.classic.JMo_Count;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Range
extends A_Object
implements I_AutoBlockDo,
I_AutoBlockList,
I_ControlObject {
    private final ArgCallBuffer argStart;
    private final ArgCallBuffer argEnd;

    public static JMo_Range createNew(CallRuntime cr, I_Object from, I_Object to) {
        return new JMo_Range(new Call(cr, from), new Call(cr, to));
    }

    public JMo_Range(Call end) {
        this.argStart = new ArgCallBuffer(0, new Call(end.surrounding, new Int(1), end.debugInfo));
        this.argEnd = new ArgCallBuffer(1, end);
    }

    public JMo_Range(Call start, Call end) {
        this.argStart = new ArgCallBuffer(0, start);
        this.argEnd = new ArgCallBuffer(1, end);
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.iEach((CallRuntime)cr, (boolean)false, (boolean)true).obj;
    }

    @Override
    public SimpleList<I_Object> autoBlockToList(CallRuntime cr) {
        return ((JMo_List)this.iEach((CallRuntime)cr, (boolean)true, (boolean)false).obj).getInternalCollection();
    }

    /*
     * Unable to fully structure code
     */
    public String computeString(CallRuntime cr) {
        block8: {
            lStart = this.argStart.get();
            lEnd = this.argEnd.get();
            if (lStart instanceof A_Number) {
                error = false;
                if (lStart instanceof I_Decimal || lEnd instanceof I_Decimal) {
                    error = true;
                } else {
                    iStart = Lib_Convert.getIntValue(cr, lStart);
                    if (iStart < 0 || iStart > 9) {
                        error = true;
                    }
                    if ((iEnd = Lib_Convert.getIntValue(cr, lEnd)) < 0 || iEnd > 9) {
                        error = true;
                    }
                }
                if (error) {
                    throw new RuntimeError(cr, "Can't convert Range to Str", "Only chars and integer numbers between 0 and 9 are allowed!");
                }
            }
            cStart = Lib_Convert.getCharValue(cr, lStart);
            cEnd = Lib_Convert.getCharValue(cr, lEnd);
            sb = new StringBuffer();
            cur = cStart;
            if (cStart > cEnd) ** GOTO lbl29
            while (cur <= cEnd) {
                sb.append(cur);
                cur = (char)(cur + '\u0001');
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                sb.append(cur);
                cur = (char)(cur - '\u0001');
lbl29:
                // 2 sources

                ** while (cur > cEnd)
            }
lbl30:
            // 1 sources

            sb.append(cur);
        }
        return sb.toString();
    }

    public Group2<I_Object, I_Object> getInternalValues() {
        return new Group2<I_Object, I_Object>(this.argStart.get(), this.argEnd.get());
    }

    @Override
    public void init(CallRuntime cr) {
        I_Object s = this.argStart.initExt(cr, this, A_Number.class, Char.class);
        I_Object e = this.argEnd.initExt(cr, this, A_Number.class, Char.class);
        if (s instanceof A_Number && !(e instanceof A_Number) || s instanceof Char && !(e instanceof Char)) {
            throw new RuntimeError(cr, "Different types for Range", Lib_Type.getName(s) + " --> " + Lib_Type.getName(e));
        }
    }

    @Override
    public String toString() {
        if (!this.isInit()) {
            return this.getTypeName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.argStart.get().toString());
        sb.append("..");
        sb.append(this.argEnd.get().toString());
        return sb.toString();
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        String s = this.argStart.toString(cr, STYPE.IDENT);
        String e = this.argEnd.toString(cr, STYPE.IDENT);
        return type == STYPE.DESCRIBE ? "Range(" + s + ',' + e + ")" : String.valueOf(s) + ".." + e;
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "toList": {
                return this.mToList(cr);
            }
            case "toCount": {
                return A_Object.stdResult(this.mToCount(cr));
            }
            case "compute": {
                return A_Object.stdResult(this.mCompute(cr));
            }
            case "each": {
                return this.mEach(cr);
            }
            case "contains": {
                return A_Object.stdResult(this.mContains(cr));
            }
        }
        return null;
    }

    private ObjectCallResult iEach(CallRuntime cr, boolean toList, boolean execBlockStream) {
        SimpleList<I_Object> list;
        I_Object start = this.argStart.get();
        I_Object end = this.argEnd.get();
        if (cr.call == null && execBlockStream) {
            Err.invalid(cr.call, toList, execBlockStream);
        }
        I_Object result = this;
        SimpleList<I_Object> simpleList = list = toList ? new SimpleList<I_Object>() : null;
        if (execBlockStream && cr.getStream() == null && cr.getCallBlock() == null) {
            return new ObjectCallResult(end, true);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = cr.copyLoop(handle);
        if (Lib_Type.typeIs(crNew, start, I_Integer.class, Char.class) && Lib_Type.typeIs(crNew, end, I_Integer.class, Char.class)) {
            int i1 = Lib_Convert.getIntValue(crNew, start, true);
            int i2 = Lib_Convert.getIntValue(crNew, end, true);
            boolean desc = i2 < i1;
            int i3 = desc ? -1 : 1;
            int i = 0;
            I_Object it = null;
            i = i1;
            while (!(desc ? i < i2 : i > i2)) {
                handle.startLap();
                boolean last = desc ? i <= i2 : i >= i2;
                it = Lib_Convert.intToObject(Lib_Type.getType(crNew, start), Lib_Type.getType(crNew, end), i);
                if (toList) {
                    list.add(it);
                } else if (execBlockStream) {
                    result = Lib_Exec.execBlockStream(crNew, it);
                    if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                        return ((Return)result).getLoopResult();
                    }
                }
                if (!last) {
                    i1 = Lib_Convert.getIntValue(crNew, start, true);
                    i2 = Lib_Convert.getIntValue(crNew, end, true);
                    desc = i2 < i1;
                    i3 = desc ? -1 : 1;
                }
                i += i3;
            }
        } else if (Lib_Type.typeIs(crNew, start, JMo_Dec.class, I_Integer.class) && Lib_Type.typeIs(crNew, end, JMo_Dec.class, I_Integer.class)) {
            Dec d1 = Lib_Convert.getDecValue(crNew, start);
            Dec d2 = Lib_Convert.getDecValue(crNew, end);
            boolean desc = d2.isLess(d1);
            Dec d = d1;
            while (!(desc ? !d.isGreaterOrEqual(d2) : !d.isLessOrEqual(d2))) {
                handle.startLap();
                boolean last = desc ? d.isLessOrEqual(d2) : d.isGreaterOrEqual(d2);
                JMo_Dec it = new JMo_Dec(d);
                if (toList) {
                    list.add(it);
                } else if (execBlockStream) {
                    result = Lib_Exec.execBlockStream(crNew, it);
                    if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                        return ((Return)result).getLoopResult();
                    }
                }
                if (!last) {
                    d1 = Lib_Convert.getDecValue(crNew, start);
                    d2 = Lib_Convert.getDecValue(crNew, end);
                    desc = d2.isLess(d1);
                }
                Dec dec = d = desc ? d.dec() : d.inc();
            }
        } else if (Lib_Type.typeIs(crNew, start, I_Decimal.class, I_Integer.class) && Lib_Type.typeIs(crNew, end, I_Decimal.class, I_Integer.class)) {
            double d1 = Lib_Convert.getDoubleValue(crNew, start);
            double d2 = Lib_Convert.getDoubleValue(crNew, end);
            boolean desc = d2 < d1;
            double d3 = desc ? -1 : 1;
            double d = d1;
            while (!(desc ? !(d >= d2) : !(d <= d2))) {
                handle.startLap();
                boolean last = desc ? d <= d2 : d >= d2;
                JMo_Double it = new JMo_Double(d);
                if (toList) {
                    list.add(it);
                } else if (execBlockStream) {
                    result = Lib_Exec.execBlockStream(crNew, it);
                    if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                        return ((Return)result).getLoopResult();
                    }
                }
                if (!last) {
                    d1 = Lib_Convert.getDoubleValue(crNew, start);
                    d2 = Lib_Convert.getDoubleValue(crNew, end);
                    desc = d2 < d1;
                    d3 = desc ? -1 : 1;
                }
                d += d3;
            }
        } else {
            throw new CodeError(crNew, "Invalid arguments", this.toString(crNew, STYPE.IDENT));
        }
        return toList ? new ObjectCallResult(new JMo_List(list), false) : new ObjectCallResult(result, true);
    }

    private I_Object mCompute(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.computeString(cr));
    }

    private Bool mContains(CallRuntime cr) {
        I_Object o = cr.argsExt(this, new Class[][]{{A_Number.class, Char.class}})[0];
        I_Object min = this.argStart.get();
        I_Object max = this.argEnd.get();
        if (min instanceof A_Number && !(o instanceof A_Number) || min instanceof Char && !(o instanceof Char)) {
            cr.warning("Different types", "Searching <" + Lib_Type.getName(o) + "> in a Range of <" + Lib_Type.getName(min) + ">");
            return Bool.FALSE;
        }
        if (min.compareTo(cr, max) > 0) {
            I_Object buffer = min;
            min = max;
            max = buffer;
        }
        if (min instanceof A_Number) {
            double io = Lib_Convert.getDoubleValue(cr, o);
            double is = Lib_Convert.getDoubleValue(cr, min);
            double ie = Lib_Convert.getDoubleValue(cr, max);
            boolean b = io >= is && io <= ie;
            return Bool.getObject(b);
        }
        if (min instanceof Char) {
            char io = ((Char)o).getValue().charValue();
            char is = ((Char)min).getValue().charValue();
            char ie = ((Char)max).getValue().charValue();
            boolean b = io >= is && io <= ie;
            return Bool.getObject(b);
        }
        throw Err.impossible(min.getClass(), o.getClass());
    }

    private ObjectCallResult mEach(CallRuntime cr) {
        cr.argsNone();
        return this.iEach(cr, false, true);
    }

    private JMo_Count mToCount(CallRuntime cr) {
        cr.argsNone();
        Call cstart = new Call(cr, this.argStart.get());
        Call cend = new Call(cr, this.argEnd.get());
        return new JMo_Count(cstart, cend, null);
    }

    private ObjectCallResult mToList(CallRuntime cr) {
        cr.argsNone();
        return this.iEach(cr, true, false);
    }
}

