/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.A_ObjectToString;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.I_Mem;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Function;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Prio;

public class Call
extends A_ObjectToString {
    public final DebugInfo debugInfo;
    public final I_Object object;
    public final String method;
    public final byte prio;
    public final Call[] argCalls;
    public final Block surrounding;
    private Block ownBlock = null;
    private Call stream = null;
    private I_Mem blockStore = null;

    public Call(Block surrBlock, I_Object obj, DebugInfo debugInfo) {
        this(surrBlock, obj, null, null, debugInfo);
    }

    public Call(Block surrBlock, I_Object obj, String met, Call[] args, DebugInfo debugInfo) {
        if (met != null && met.length() == 0) {
            Err.invalid(met);
        }
        Err.ifNull((Object)surrBlock);
        this.surrounding = surrBlock;
        this.object = obj;
        this.method = met;
        this.argCalls = args;
        this.prio = (byte)(met == null || args != null && args.length != 1 ? 99 : (int)Lib_Prio.streamPrio(met, debugInfo));
        this.debugInfo = debugInfo;
    }

    public Call(CallRuntime cr, I_Object obj) {
        this(cr.getSurrBlock(), obj, null, null, cr.getDebugInfo());
    }

    public Call copy(I_Object obj, String method, Call[] args) {
        Call c2 = new Call(this.surrounding, obj, method, args, this.debugInfo);
        if (this.hasBlock()) {
            c2.setBlock(this.getBlock());
        }
        if (this.hasStream()) {
            c2.setStream(this.getStream());
        }
        if (this.blockStore != null) {
            c2.setBlockStore(this.blockStore);
        }
        return c2;
    }

    public int getArgCount() {
        return this.argCalls == null ? 0 : this.argCalls.length;
    }

    public Block getBlock() {
        return this.ownBlock;
    }

    public I_Mem getBlockStore() {
        return this.blockStore;
    }

    public Call getStream() {
        return this.stream;
    }

    public boolean hasBlock() {
        return this.ownBlock != null;
    }

    public boolean hasObject() {
        return this.object != null;
    }

    public boolean hasStream() {
        return this.stream != null;
    }

    public Call searchLastCall() {
        if (this.method != null && Lib_Function.isVarFunction(this.method) > -1 && this.argCalls != null && this.argCalls.length > 0) {
            return this.argCalls[0].searchLastCall();
        }
        if (this.stream == null) {
            return this;
        }
        return this.stream.searchLastCall();
    }

    public void setBlock(Block b) {
        Err.ifNull((Object)b);
        if (this.ownBlock != null) {
            Err.invalid(this.ownBlock, b);
        }
        this.ownBlock = b;
    }

    public void setBlockStore(I_Mem vc) {
        this.blockStore = vc;
    }

    public void setStream(Call c) {
        Err.ifNull((Object)c);
        if (this.stream != null) {
            throw Err.invalid(this.toString(), this.stream, c);
        }
        this.stream = c;
    }

    @Override
    public String toString() {
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(null, this.object, this.method, false);
        String p = Lib_Output.toString(this.argCalls);
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        String a = this.ownBlock != null || this.stream != null ? "\u2026" : "";
        return String.valueOf((String)g.o1) + p + a;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return this.toString(cr, type, false);
    }

    public String toString(CallRuntime cr, STYPE type, boolean replaceMem) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.toString();
            }
            case IDENT: {
                return this.toStringIdent(cr, true, replaceMem);
            }
            case DESCRIBE: {
                return this.toStringDescribe(cr, replaceMem);
            }
        }
        throw Err.impossible(new Object[]{type});
    }

    private StringBuilder iToString(CallRuntime cr, boolean replaceMem) {
        boolean isAssign;
        StringBuilder sb = new StringBuilder();
        I_Object obj = this.object;
        boolean bl = isAssign = this.method != null && this.method.indexOf(61) >= 0;
        if (replaceMem && obj instanceof I_Mem && ((I_Mem)obj).isInitialized(cr) && !isAssign) {
            obj = Lib_Convert.getValue(cr, obj);
        }
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(cr, obj, this.method, false);
        sb.append((String)g.o1);
        if (this.argCalls != null && this.argCalls.length > 0) {
            sb.append((Boolean)g.o2 != false ? (char)' ' : '(');
            int i = 0;
            while (i < this.argCalls.length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.argCalls[i].toStringIdent(cr, true, isAssign ? false : replaceMem));
                ++i;
            }
            if (!((Boolean)g.o2).booleanValue()) {
                sb.append(')');
            }
        }
        return sb;
    }

    private String toStringDescribe(CallRuntime cr, boolean replaceMem) {
        StringBuilder sb = this.iToString(cr, replaceMem);
        if (this.ownBlock != null) {
            sb.append("{<Block>}");
        }
        if (this.stream != null) {
            sb.append(this.stream.toStringDescribe(cr, replaceMem));
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    private String toStringIdent(CallRuntime cr, boolean addBlockStreamChar, boolean replaceMem) {
        StringBuilder sb = this.iToString(cr, replaceMem);
        String bs = addBlockStreamChar && (this.ownBlock != null || this.stream != null) ? "\u2026" : "";
        sb.append(bs);
        return sb.toString();
    }
}

