/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing.comp;

import de.mn77.base.data.struct.I_Series;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.ArrayTable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jaymo_lang.lib.swing.comp.A_Swing_JComponent;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Swing_Table
extends A_Swing_JComponent {
    private JTable table;
    private JScrollPane pane;
    private ArgCallBuffer initTable = null;
    private JMo_Table data = null;

    public JMo_Swing_Table() {
    }

    public JMo_Swing_Table(Call table) {
        this.initTable = new ArgCallBuffer(0, table);
    }

    @Override
    public I_Object callMethod4(CallRuntime cr, String method) {
        switch (method) {
            case "set": 
            case "setData": {
                this.data = (JMo_Table)cr.args(this, JMo_Table.class)[0];
                this.iSetData(cr, this.data);
                return this;
            }
            case "selection": {
                return this.mSelection(cr);
            }
            case "selectionTable": {
                return this.mSelectionTable(cr);
            }
            case "selectionRow": {
                return this.mSelectionRow(cr);
            }
            case "selectRow": 
            case "selectRows": {
                this.iSelectRows(cr);
                return this;
            }
            case "selectAll": {
                this.iSelectAll(cr, true);
                return this;
            }
            case "selectNone": {
                this.iSelectAll(cr, false);
                return this;
            }
            case "scrollTop": {
                this.iScrollTop(cr, false);
                return this;
            }
        }
        return null;
    }

    @Override
    public Component getSwing() {
        return this.pane;
    }

    @Override
    public void init(final CallRuntime cr) {
        this.table = new JTable();
        this.pane = new JScrollPane(this.table);
        if (this.initTable != null) {
            JMo_Table o = this.initTable.init(cr, this, JMo_Table.class);
            this.iSetData(cr, o);
        }
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JMo_Swing_Table.this.eventRun(cr, "@select", JMo_Swing_Table.this);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@select": {
                return true;
            }
        }
        return false;
    }

    private void iScrollTop(CallRuntime cr, boolean all) {
        cr.argsNone();
        SwingUtilities.invokeLater(() -> this.pane.getVerticalScrollBar().setValue(0));
    }

    private void iSelectAll(CallRuntime cr, boolean all) {
        cr.argsNone();
        if (all) {
            this.table.selectAll();
            this.eventRun(cr, "@select", this);
        } else {
            this.table.clearSelection();
        }
    }

    private void iSelectRows(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        this.table.clearSelection();
        if (args.length == 1) {
            if (args[0] instanceof JMo_List) {
                I_Series positions = ((JMo_List)args[0]).getInternalCollection();
                for (I_Object o : positions) {
                    int pos = Lib_Convert.getIntValue(cr, cr.argType(o, A_IntNumber.class)) - 1;
                    this.table.addRowSelectionInterval(pos, pos);
                }
            } else {
                int pos = Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class)) - 1;
                this.table.addRowSelectionInterval(pos, pos);
            }
        } else {
            int from = Lib_Convert.getIntValue(cr, cr.argType(args[0], A_IntNumber.class)) - 1;
            int to = Lib_Convert.getIntValue(cr, cr.argType(args[1], A_IntNumber.class)) - 1;
            this.table.addRowSelectionInterval(from, to);
        }
        this.eventRun(cr, "@select", this);
    }

    private void iSetData(CallRuntime cr, final JMo_Table table) {
        final ArrayTable<I_Object> al = table.getInternalObject();
        AbstractTableModel model = new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getColumnCount() {
                return al.width();
            }

            @Override
            public String getColumnName(int column) {
                I_Object[] names = table.getInternalColumnNames();
                return names == null ? "" : names[column].toString();
            }

            @Override
            public int getRowCount() {
                return al.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                return al.get(col + 1, row + 1);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(model);
    }

    private I_Object mSelection(CallRuntime cr) {
        cr.argsNone();
        int[] selected = this.table.getSelectedRows();
        SimpleList<I_Object> al = new SimpleList<I_Object>(selected.length);
        int[] nArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            al.add(new Int(element + 1));
            ++n2;
        }
        return new JMo_List(al);
    }

    private I_Object mSelectionRow(CallRuntime cr) {
        cr.argsNone();
        int selected = this.table.getSelectedRow();
        if (selected == -1 || this.data == null) {
            return Nil.NIL;
        }
        I_Object[] row1 = this.data.getInternalObject().getRow(selected + 1);
        SimpleList<I_Object> al = new SimpleList<I_Object>(row1.length);
        al.addMore(row1);
        return new JMo_List(al);
    }

    private I_Object mSelectionTable(CallRuntime cr) {
        cr.argsNone();
        int[] selected = this.table.getSelectedRows();
        ArrayTable<I_Object> source = this.data.getInternalObject();
        ArrayTable<I_Object> result = new ArrayTable<I_Object>(source.width());
        int[] nArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            int sel = nArray[n2];
            I_Object[] row = (I_Object[])source.getRow(sel);
            result.add((T[])row);
            ++n2;
        }
        return new JMo_Table(result);
    }
}

