/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.error;

import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.error.Err;
import de.mn77.base.error.I_ErrorDetails;
import de.mn77.base.error.I_ErrorInfo;
import de.mn77.base.sys.MOut;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ErrorBase;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ErrorComposer;

public abstract class ErrorBaseDebug
extends ErrorBase
implements I_ErrorDetails,
I_ErrorInfo {
    private static final long serialVersionUID = 8587625424636880857L;
    private final DebugInfo source;
    private final String call;
    private final Instance instance;
    private final String instanceStringNested;
    private final String object;
    private final CallRuntime crOrigin;
    private StackTraceElement[] ste = null;

    protected ErrorBaseDebug(String message, String detail, CallRuntime cr, DebugInfo source) {
        super(message, detail);
        this.crOrigin = cr;
        this.source = source;
        this.object = cr == null || cr.getCurrentObject() == null || cr.call.hasObject() ? null : cr.getCurrentObject().toString(cr, STYPE.IDENT);
        this.call = cr == null || cr.call == null ? null : cr.call.toString(cr, STYPE.IDENT, true);
        this.instance = cr == null ? null : cr.instance;
        String string = this.instanceStringNested = this.instance == null ? null : this.instance.toString(cr, STYPE.IDENT);
        if (MOut.isLogUsed()) {
            MOut.logErr(this.toInfo());
        }
    }

    @Override
    public void addDetail(Object ... oa) {
        Err.todo(oa);
    }

    public void addTrace(StackTraceElement[] ste) {
        this.ste = ste;
    }

    public String getCall() {
        return this.call;
    }

    public CallRuntime getCallRuntime() {
        return this.crOrigin;
    }

    @Override
    public Iterable<Object> getDetails() {
        SimpleList<Object> list = new SimpleList<Object>();
        if (this.getDetail() != null) {
            list.add("Detail  : " + this.getDetail());
        }
        if (this.call != null) {
            list.add("Call    : " + (this.object != null ? this.object : "") + this.call);
        }
        if (this.instanceStringNested != null) {
            list.add("Instance: " + this.instanceStringNested);
        }
        if (this.ste != null && MOut.isModeDev()) {
            StackTraceElement[] stackTraceElementArray = this.ste;
            int n = this.ste.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                list.add("  Java@ " + e.toString());
                ++n2;
            }
        }
        return list;
    }

    public abstract String getErrorTypeInfo();

    public String getFile() {
        return this.source == null ? null : this.source.getRawFile();
    }

    public String getInstance() {
        return this.instance.toString();
    }

    public Integer getLine() {
        return this.source == null ? null : this.source.getRawLine();
    }

    public String getSource() {
        return "" + this.source;
    }

    @Override
    public String toInfo() {
        return new ErrorComposer(this, this.crOrigin).compose();
    }
}

