/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor.border;

import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;
import de.mn77.base.sys.file.Lib_Jar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.InputStream;
import javax.swing.border.AbstractBorder;
import org.jaymo_lang.edit.editor.CodeEditor;

public class LineNumberedBorder
extends AbstractBorder {
    private static final long serialVersionUID = -3812536735962506061L;
    private static final Color COLOR_NUMBERS = Color.DARK_GRAY;
    private static final Color COLOR_SEPARATORLINE = Color.LIGHT_GRAY;
    private static final Color COLOR_BACKGROUND = new Color(238, 238, 238);
    private static final int offsetEditX = 3;
    private static final int MAX_LINENR = 999;
    private final Font font;

    private static String padLabel(int lineNumber, int length) {
        int spaces = 3;
        return String.valueOf(Lib_String.sequence(' ', 3L)) + lineNumber + ' ';
    }

    public LineNumberedBorder() {
        Font f = null;
        try {
            InputStream is = Lib_Jar.getStream("/jar/font/dejavu/DejaVuSansMono.ttf");
            f = Font.createFont(0, is).deriveFont(15.0f);
        }
        catch (Exception e) {
            Err.show(e);
        }
        this.font = f;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof CodeEditor) {
            insets.left = this.lineNumberWidth((CodeEditor)c) + 3;
        }
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        CodeEditor jta;
        int yend;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        Rectangle clip = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int ybaseline = y + fm.getAscent();
        int startingLineNumber = clip.y / fontHeight + 1;
        if (ybaseline < clip.y) {
            ybaseline = y + startingLineNumber * fontHeight - (fontHeight - fm.getAscent());
        }
        if ((yend = (jta = (CodeEditor)c).getLineCount() * fontHeight) > y + height) {
            yend = y + height;
        }
        int lineWidth = this.lineNumberWidth(jta);
        int lnxstart = x + lineWidth;
        g.setColor(COLOR_BACKGROUND);
        g.fillRect(0, 0, lineWidth, yend * lineWidth);
        g.setColor(COLOR_NUMBERS);
        g.setFont(this.font);
        int length = ("" + jta.getLineCount() + 1).length();
        while (ybaseline < yend) {
            String label = LineNumberedBorder.padLabel(startingLineNumber, length);
            g.drawString(label, lnxstart - fm.stringWidth(label), ybaseline);
            ybaseline += fontHeight;
            ++startingLineNumber;
        }
        g.setColor(COLOR_SEPARATORLINE);
        lnxstart = x + lineWidth - 1;
        g.drawLine(lnxstart, 0, lnxstart, height);
    }

    private int lineNumberWidth(CodeEditor textArea) {
        int lineCount = textArea.getLineCount() + 1;
        lineCount = Math.max(lineCount, 999);
        return textArea.getFontMetrics(textArea.getFont()).stringWidth(String.valueOf(lineCount) + " ");
    }
}

