/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.xml;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XML_Output {
    private XMLStreamWriter writer;
    private OutputStream stream;

    public XML_Output(OutputStream os) throws Err_Exception {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = factory.createXMLStreamWriter(os);
            this.writer.writeStartDocument();
            this.writer.writeCharacters("\n");
            this.stream = os;
        }
        catch (XMLStreamException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
    }

    public XML_Output(OutputStream os, String encoding) throws Err_Exception {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = factory.createXMLStreamWriter(os);
            this.writer.writeStartDocument(encoding, "1.0");
            this.stream = os;
        }
        catch (XMLStreamException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
    }

    public void attribute(String name, String wert) throws Err_Exception {
        try {
            this.writer.writeAttribute(name, wert);
        }
        catch (XMLStreamException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
    }

    public void attributeNull(String name, String wert) throws Err_Exception {
        if (wert != null) {
            this.attribute(name, wert);
        }
    }

    public void close() throws Err_Exception {
        try {
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
    }

    public void close(String wirdnichtverwendet) throws Err_Exception {
        this.close();
    }

    public void finish() throws Err_Exception {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
            this.stream.close();
        }
        catch (XMLStreamException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
        catch (IOException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    public void open(String name) throws Err_Exception {
        try {
            this.writer.writeStartElement(name);
        }
        catch (XMLStreamException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
    }

    public void quickText(String name, String text) throws Err_Exception {
        this.open(name);
        this.text(text);
        this.close();
    }

    public void text(String text) throws Err_Exception {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            Err.wrap(e, "Schreiben fehlgeschlagen");
        }
    }
}

