/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.lang;

import de.mn77.base.data.convert.ConvertString;
import de.mn77.base.data.form.FormString;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.lib.lang.PoData;
import de.mn77.lib.lang.PoItem;
import java.io.File;
import java.util.List;

public class PoReader {
    public static PoData read(File poFile) throws Err_FileSys {
        String fileContent = Lib_TextFile.read(poFile);
        List<String> lines = ConvertString.toLines(fileContent);
        PoData data = new PoData();
        STR_TYPE type = STR_TYPE.ID;
        PoItem current = new PoItem();
        for (String line : lines) {
            if (line.length() == 0) {
                if (current.getId() != null) {
                    data.add(current);
                }
                current = new PoItem();
                continue;
            }
            if (line.startsWith("msgid ")) {
                type = STR_TYPE.ID;
                current.idAppend(FormString.unquote(line.substring(6), '\"', '\"'));
                continue;
            }
            if (line.startsWith("msgstr ")) {
                type = STR_TYPE.STR;
                current.strAppend(FormString.unquote(line.substring(7), '\"', '\"'));
                continue;
            }
            if (line.startsWith("\"")) {
                line = FormString.unquote(line, '\"', '\"');
                if (type == STR_TYPE.ID) {
                    current.idAppend(line);
                    continue;
                }
                if (type != STR_TYPE.STR) continue;
                current.strAppend(line);
                continue;
            }
            if (line.equals("#") || line.startsWith("# ")) {
                current.addComment(line);
                continue;
            }
            if (line.equals("#, fuzzy")) {
                current.setFuzzy();
                continue;
            }
            if (line.startsWith("#~| msgid ") || line.startsWith("#~")) continue;
            if (line.startsWith("#|")) {
                current.setFuzzy();
                continue;
            }
            Err.todo(line);
        }
        return data;
    }

    private static enum STR_TYPE {
        ID,
        STR;

    }
}

