/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.crypt;

import de.mn77.base.data.struct.atomic.ByteList;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;

public class CodecBase32 {
    public static final char[] charsBase32hex = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
    public static final char[] charsBase32 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();

    public static byte[] decodeToBytes(String s) {
        return CodecBase32.decode(charsBase32, s);
    }

    public static byte[] decodeToBytesHex(String s) {
        return CodecBase32.decode(charsBase32hex, s);
    }

    public static String decodeToString(String s) {
        byte[] ba = CodecBase32.decode(charsBase32, s);
        return new String(ba);
    }

    public static String decodeToStringHex(String s) {
        byte[] ba = CodecBase32.decode(charsBase32hex, s);
        return new String(ba);
    }

    public static String encode(byte[] ba) {
        return CodecBase32.encode(charsBase32, ba);
    }

    public static String encode(String s) {
        return CodecBase32.encode(charsBase32, s.getBytes());
    }

    public static String encodeHex(byte[] ba) {
        return CodecBase32.encode(charsBase32hex, ba);
    }

    public static String encodeHex(String s) {
        return CodecBase32.encode(charsBase32hex, s.getBytes());
    }

    public static void main(String[] args) {
        CodecBase32.test("");
        CodecBase32.test("f");
        CodecBase32.test("fo");
        CodecBase32.test("foo");
        CodecBase32.test("foob");
        CodecBase32.test("fooba");
        CodecBase32.test("foobar");
        CodecBase32.test("Bitte beachten Sie auch die Hinweise unter: Encoding / Codepage / Charset.");
    }

    private static byte[] decode(char[] chars, String s) {
        if (s.length() == 0) {
            return new byte[0];
        }
        if (s.length() % 8 != 0) {
            throw Err.invalid("Invalid source to decode. The length must be divisible by 8!");
        }
        ByteList bl = new ByteList();
        char[] ca = s.toCharArray();
        int pCa = 0;
        int left = 5;
        char c = '\u0000';
        byte b = 0;
        int needed = 8;
        while (pCa < ca.length - 1 || pCa == ca.length - 1 && left > 0) {
            c = ca[pCa];
            if (c == '=') break;
            needed = 8;
            if (left == 0) {
                left = 5;
            }
            b = CodecBase32.indexOf(chars, c);
            b = (byte)(b << 8 - left);
            needed = (byte)(needed - left);
            while (needed > 0) {
                if ((c = ca[++pCa]) == '=') break;
                left = 5;
                byte b2 = CodecBase32.indexOf(chars, c);
                if (needed > 5) {
                    b2 = (byte)(b2 << needed - 5);
                } else if (needed < 5) {
                    b2 = (byte)(b2 >> 5 - needed);
                }
                b = (byte)(b + b2);
                left -= needed;
                needed = (byte)(needed - 5);
                if (needed > 0) continue;
                bl.add(b);
            }
            if (left != 0) continue;
            ++pCa;
        }
        return bl.toArray();
    }

    private static String encode(char[] chars, byte[] ba) {
        if (ba.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int pBa = 0;
        int pBit = 0;
        byte b = 0;
        while (pBa < ba.length - 1 || pBa == ba.length - 1 && pBit <= 3) {
            b = ba[pBa];
            if (pBit <= 3) {
                b = (byte)(b >> 3 - pBit);
                b = (byte)(b - (b & 0xE0));
            } else {
                b = (byte)(b << pBit - 3);
                b = (byte)(b - (b & 0xE0));
                byte b2 = ba[pBa + 1];
                b2 = (byte)(b2 >> 11 - pBit);
                b = (byte)(b + b2);
            }
            sb.append(chars[b]);
            if ((pBit += 5) < 8) continue;
            pBit -= 8;
            ++pBa;
        }
        if (pBa == ba.length - 1 && pBit <= 7) {
            b = ba[pBa];
            b = (byte)(b << pBit - 3);
            b = (byte)(b - (b & 0xE0));
            sb.append(chars[b]);
        }
        while (sb.length() % 8 > 0) {
            sb.append('=');
        }
        return sb.toString();
    }

    private static byte indexOf(char[] chars, char c) {
        if (c == '=') {
            return 0;
        }
        byte i = 0;
        while (i < chars.length) {
            if (chars[i] == c) {
                return i;
            }
            i = (byte)(i + 1);
        }
        throw Err.invalid("Invalid char: " + c);
    }

    private static void test(String s) {
        String fe = CodecBase32.encode(s);
        String fd = CodecBase32.decodeToString(fe);
        MOut.print("-----", s, fe, fd);
    }
}

