/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import java.io.File;
import java.io.RandomAccessFile;

public class Lib_RandomAccess {
    public static void append(File file, byte[] ba) throws Err_FileSys {
        Lib_RandomAccess.write(file, -1L, ba);
    }

    public static int checkReadSize(File file, long len) throws Err_FileSys {
        if (len > 0x7FFFFFF7L) {
            throw new Err_FileSys("File too big to read: \"" + file.getAbsolutePath() + '\"', new Object[0]);
        }
        return (int)len;
    }

    public static void clear(File file) throws Err_FileSys {
        Lib_RandomAccess.write(file, null, new byte[0]);
    }

    public static byte[] read(File file) throws Err_FileSys {
        return Lib_RandomAccess.read(file, 0L, null);
    }

    public static byte[] read(File file, long index) throws Err_FileSys {
        return Lib_RandomAccess.read(file, index, null);
    }

    public static byte[] read(File file, long index, Long length) throws Err_FileSys {
        Err.ifNull((Object)file);
        RandomAccessFile raf = null;
        try {
            int bytesToRead;
            byte[] ba;
            int got;
            raf = new RandomAccessFile(file, "r");
            if (index > 0L) {
                raf.seek(index);
            }
            if (length == null) {
                length = raf.length();
            }
            if ((got = raf.read(ba = new byte[bytesToRead = Lib_RandomAccess.checkReadSize(file, length)])) != bytesToRead) {
                throw new Err_FileSys("File-Read-Error, got " + got + " bytes instead of " + bytesToRead + ": \"" + file.getAbsolutePath() + '\"', new Object[0]);
            }
            byte[] byArray = ba;
            return byArray;
        }
        catch (Exception err) {
            throw Err.fsAccess("File read error", err);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }

    public static void set(File file, byte[] ba) throws Err_FileSys {
        Lib_RandomAccess.write(file, null, ba);
    }

    public static void write(File file, Long index, byte[] ba) throws Err_FileSys {
        Err.ifNull(file, ba);
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                if (index == null) {
                    raf.setLength(0L);
                } else if (index < 0L) {
                    raf.seek(raf.length());
                } else {
                    raf.seek(index);
                }
                if (ba.length > 0) {
                    raf.write(ba);
                }
            }
            catch (Exception err) {
                throw Err.fsAccess(err, file);
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }
}

