/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys;

import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.util.Lib_Array;
import de.mn77.base.debug.DEBUG_MODE;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.SysDir;
import de.mn77.base.sys.out.CHANNEL_IN;
import de.mn77.base.sys.out.CHANNEL_OUT;
import de.mn77.base.sys.out.MOutWriter;
import de.mn77.base.sys.out.OUTPUT_DETAIL;
import de.mn77.base.sys.out.OUTPUT_STYLE;
import de.mn77.base.sys.out.TRACE;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class MOut {
    private static boolean fastOut = true;
    private static boolean useLog = false;
    private static String linebreak = System.lineSeparator();
    private static final MOutWriter writer = new MOutWriter();

    public static void describe(Object ... oa) {
        writer.write(CHANNEL_IN.OUT, OUTPUT_DETAIL.DESCRIBE, TRACE.NO, false, true, null, oa);
    }

    public static void dev(Object ... oa) {
        writer.write(CHANNEL_IN.DEV, OUTPUT_DETAIL.RAW, TRACE.NO, false, true, null, oa);
    }

    public static void echo(Object ... oa) {
        writer.write(CHANNEL_IN.OUT, OUTPUT_DETAIL.RAW, TRACE.NO, false, false, null, oa);
    }

    public static void echo(String s) {
        if (fastOut) {
            writer.directOut(s);
        } else {
            MOut.echo(new Object[]{s});
        }
    }

    public static void echoErr(Object ... oa) {
        writer.write(CHANNEL_IN.ERR, OUTPUT_DETAIL.RAW, TRACE.NO, false, false, null, oa);
    }

    public static void error(String text) {
        MOut.error(new RuntimeException(), text);
    }

    public static void error(Throwable t) {
        MOut.error(t, null);
    }

    public static void error(Throwable t, String text) {
        writer.writeError(t, text, false);
    }

    public static void exit(Object ... oa) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        String message = "!!! DEBUG EXIT !!!";
        Object[] oa2 = Lib_Array.append(oa, (Object)"!!! DEBUG EXIT !!!");
        writer.write(CHANNEL_IN.ERR, OUTPUT_DETAIL.RAW, TRACE.FULL, false, true, ste, oa2);
        System.exit(1);
    }

    public static boolean getJavaErrors() {
        return writer.getJavaErrors();
    }

    public static String getLineBreak() {
        return linebreak;
    }

    public static void ident(Object ... oa) {
        writer.write(CHANNEL_IN.OUT, OUTPUT_DETAIL.IDENT, TRACE.NO, false, true, null, oa);
    }

    public static boolean isLogUsed() {
        return useLog;
    }

    public static boolean isModeDev() {
        return !fastOut;
    }

    public static void line(Object ... oa) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        writer.write(CHANNEL_IN.OUT, OUTPUT_DETAIL.RAW, TRACE.ONE, false, true, ste, oa);
    }

    public static void log(Object ... oa) {
        writer.write(CHANNEL_IN.LOG, OUTPUT_DETAIL.RAW, TRACE.NO, false, true, null, oa);
    }

    public static void logErr(Object ... oa) {
        writer.writeLog(CHANNEL_IN.ERR, TRACE.NO, false, null, oa);
    }

    public static void print() {
        if (fastOut) {
            writer.directOut(linebreak);
        } else {
            MOut.print(new Object[]{""});
        }
    }

    public static void print(Object ... oa) {
        writer.write(CHANNEL_IN.OUT, OUTPUT_DETAIL.RAW, TRACE.NO, false, true, null, oa);
    }

    public static void print(String s) {
        if (fastOut) {
            writer.directOut(String.valueOf(s) + linebreak);
        } else {
            MOut.print(new Object[]{s});
        }
    }

    public static void printErr(Object ... oa) {
        writer.write(CHANNEL_IN.ERR, OUTPUT_DETAIL.RAW, TRACE.NO, false, true, null, oa);
    }

    public static void reset() {
        MOut.setDebug(DEBUG_MODE.NO);
    }

    public static void setDebug() {
        MOut.setDebug(DEBUG_MODE.MINIMAL);
    }

    public static void setDebug(DEBUG_MODE debug) {
        if (debug == DEBUG_MODE.NO) {
            MOut.setDeveloper(false);
            writer.setStyle(OUTPUT_STYLE.RAW);
        } else {
            MOut.setDeveloper(true);
            if (debug == DEBUG_MODE.MINIMAL) {
                writer.setStyle(OUTPUT_STYLE.CHANNEL);
            } else if (debug == DEBUG_MODE.DETAIL) {
                writer.setStyle(OUTPUT_STYLE.TIMESTAMP);
            } else {
                writer.setStyle(OUTPUT_STYLE.TIMESTAMP);
                writer.setDefaultTrace(TRACE.ONE);
            }
        }
    }

    public static void setDeveloper(boolean enable) {
        if (enable) {
            fastOut = false;
            writer.setModeDeveloper();
        } else {
            fastOut = true;
            writer.setModeRaw();
        }
    }

    public static void setJavaErrors(boolean b) {
        writer.setJavaErrors(b);
    }

    public static void setLineBreak(String s) {
        linebreak = s;
        writer.setLineBreak(s);
    }

    public static void setLog(String appName) throws Err_FileSys {
        Err.ifEmpty(appName);
        I_Directory dir = SysDir.userConfig_MN77(appName).dirFlex("logs");
        MOut.setLogDir(dir);
    }

    public static void setLogDir(I_Directory dir) {
        Err.ifNull((Object)dir);
        useLog = true;
        writer.setLogFile(dir.fileMay(new MDateTime().toStringFileSysSlim(), "txt").getFile());
    }

    public static void setLogFile(File file) {
        Err.ifNull((Object)file);
        useLog = true;
        writer.setLogFile(file);
    }

    public static void setRouteDev(CHANNEL_OUT ... targets) {
        writer.routeDev(targets);
    }

    public static void setRouteErr(CHANNEL_OUT ... targets) {
        writer.routeErr(targets);
    }

    public static void setRouteLog(CHANNEL_OUT ... targets) {
        writer.routeLog(targets);
    }

    public static void setRouteOut(CHANNEL_OUT ... targets) {
        writer.routeOut(targets);
        fastOut = false;
    }

    public static void setRouteWrn(CHANNEL_OUT ... targets) {
        writer.routeWrn(targets);
    }

    public static void setStyle(OUTPUT_STYLE style) {
        writer.setStyle(style);
        fastOut = style == OUTPUT_STYLE.RAW;
    }

    public static OutputStream streamError() {
        return MOut.iStream(CHANNEL_IN.ERR);
    }

    public static OutputStream streamText() {
        return MOut.iStream(CHANNEL_IN.OUT);
    }

    public static void temp(Object ... oa) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        writer.write(CHANNEL_IN.ERR, OUTPUT_DETAIL.IDENT, TRACE.ONE, false, true, ste, oa);
    }

    public static void trace(Object ... oa) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        writer.write(CHANNEL_IN.OUT, OUTPUT_DETAIL.RAW, TRACE.FULL, false, true, ste, oa);
    }

    public static void warning(Object ... oa) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        writer.write(CHANNEL_IN.WRN, OUTPUT_DETAIL.RAW, TRACE.ONE, false, true, ste, oa);
    }

    private static PrintStream iStream(final CHANNEL_IN channel) {
        return new PrintStream(new OutputStream(){
            private final StringBuilder sb = new StringBuilder();

            @Override
            public void close() throws IOException {
                super.close();
                writer.write(channel, OUTPUT_DETAIL.RAW, TRACE.NO, false, false, null, new Object[]{this.sb.toString()});
            }

            @Override
            public void write(int i) throws IOException {
                this.sb.append(new String(new byte[]{(byte)i}));
            }
        });
    }
}

