/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type;

import de.mn77.base.error.Err;

public class Lib_Compare {
    public static boolean isEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null || o1.getClass() != o2.getClass()) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean isGreater(Object base, Object than) {
        if (Lib_Compare.isEqual(base, than)) {
            return false;
        }
        if (base != null && than == null) {
            return true;
        }
        if (base == null && than != null) {
            return false;
        }
        if (base instanceof Character && than instanceof Character) {
            return Lib_Compare.isGreaterChar(((Character)base).charValue(), ((Character)than).charValue());
        }
        if (base instanceof String && than instanceof String) {
            return Lib_Compare.isGreaterString((String)base, (String)than);
        }
        if (base.getClass() == than.getClass() && base instanceof Comparable) {
            return ((Comparable)base).compareTo(than) > 0;
        }
        return Lib_Compare.isGreaterString(base.toString(), than.toString());
    }

    public static boolean isGreaterChar(char c1, char c2) {
        if (c1 == c2) {
            return false;
        }
        char v1 = Lib_Compare.iNormalizeChars(c1);
        char v2 = Lib_Compare.iNormalizeChars(c2);
        int greaterCase = Lib_Compare.iCompareCase(c1, c2);
        if (v1 != v2) {
            return v1 > v2;
        }
        if (greaterCase > 0) {
            return true;
        }
        if (greaterCase < 0) {
            return false;
        }
        return c1 > c2;
    }

    public static boolean isGreaterString(String s1, String s2) {
        Err.ifNull(s1, s2);
        int min = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < min) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i))) {
                return Lib_Compare.isGreaterChar(c1, c2);
            }
            ++i;
        }
        if (s1.length() != s2.length()) {
            return s1.length() > s2.length();
        }
        return false;
    }

    public static boolean isSmaller(Object base, Object than) {
        return Lib_Compare.isGreater(than, base);
    }

    private static int iCompareCase(char c1, char c2) {
        boolean u2;
        boolean u1 = Character.isUpperCase(c1);
        if (u1 == (u2 = Character.isUpperCase(c2))) {
            return 0;
        }
        if (u1 && !u2) {
            return -1;
        }
        return 1;
    }

    private static char iNormalizeChars(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c;
        }
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        if (c < '\u00c0') {
            return c;
        }
        if (c >= '\u00c0' && c <= '\u00c6') {
            return 'A';
        }
        if (c == '\u00c7') {
            return 'C';
        }
        if (c >= '\u00c8' && c <= '\u00cb') {
            return 'E';
        }
        if (c >= '\u00cc' && c <= '\u00cf') {
            return 'I';
        }
        if (c == '\u00d1') {
            return 'N';
        }
        if (c >= '\u00d2' && c <= '\u00d6') {
            return 'O';
        }
        if (c >= '\u00d9' && c <= '\u00dc') {
            return 'U';
        }
        if (c == '\u00dd') {
            return 'Y';
        }
        if (c == '\u1e9e') {
            return 'S';
        }
        if (c >= '\u00e0' && c <= '\u00e6') {
            return 'A';
        }
        if (c == '\u00e7') {
            return 'C';
        }
        if (c >= '\u00e8' && c <= '\u00eb') {
            return 'E';
        }
        if (c >= '\u00ec' && c <= '\u00ef') {
            return 'I';
        }
        if (c == '\u00f1') {
            return 'N';
        }
        if (c >= '\u00f2' && c <= '\u00f6') {
            return 'O';
        }
        if (c >= '\u00f9' && c <= '\u00fc') {
            return 'U';
        }
        if (c == '\u00fd' || c == '\u00ff') {
            return 'Y';
        }
        if (c == '\u00df') {
            return 'S';
        }
        return c;
    }
}

