/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.tablestyle.calc;

import de.mn77.base.data.util.Lib_String;
import de.mn77.base.error.Err;

public class TableBorderCalc {
    private static final String COL_LINE_UNI = "\u2502";
    private static final String COL_LINE2_UNI = " \u2502 ";
    private static final String COL_LINE_ASC = "|";
    private static final String COL_LINE2_ASC = " | ";
    private final boolean border;
    private final boolean unicode;
    private final Character columnLineDefault;
    private final String columnLines;
    private final Character rowLineDefault;
    private final String rowLines;
    private final int[] widths;
    private final int tabLen;
    private final String[] xCol;
    private final String[] xRow;
    private final String indent;
    private String bufferRowLineSingle = null;
    private String bufferRowLineEmpty = null;
    private String bufferRowLineDouble = null;

    public TableBorderCalc(boolean border, boolean unicode, Character colDefault, String cols, Character rowDefault, String rows, int[] widths, int tabLen, String indent) {
        this.border = border;
        this.unicode = unicode;
        this.columnLineDefault = colDefault;
        this.columnLines = cols;
        this.rowLineDefault = rowDefault;
        this.rowLines = rows;
        this.widths = widths;
        this.tabLen = tabLen;
        this.indent = indent;
        this.xCol = this.computeColLines();
        this.xRow = this.computeRowLines();
    }

    public void afterColumn(StringBuilder sb, int col) {
        if (col >= this.widths.length - 1) {
            return;
        }
        String line = this.xCol[col];
        if (line != null) {
            sb.append(line);
        }
    }

    public boolean borderBottom(StringBuilder sb) {
        if (!this.border) {
            return false;
        }
        if (this.unicode) {
            this.iComputeLine(sb, '\u2514', '\u2518', '\u2500', '\u2534', "\u2500\u2534\u2500");
        } else {
            this.iComputeLine(sb, '\'', '\'', '-', '-', "---");
        }
        return true;
    }

    public void borderTop(StringBuilder sb) {
        if (!this.border) {
            return;
        }
        if (this.unicode) {
            this.iComputeLine(sb, '\u250c', '\u2510', '\u2500', '\u252c', "\u2500\u252c\u2500");
        } else {
            this.iComputeLine(sb, '.', '.', '-', '-', "---");
        }
        sb.append('\n');
    }

    public void lineEnd(StringBuilder sb, int row) {
        String line;
        if (this.border) {
            sb.append(this.unicode ? (char)'\u2502' : '|');
        }
        if (row != this.tabLen - 1 && (line = this.xRow[row]) != null) {
            sb.append('\n');
            sb.append(line);
        }
        sb.append('\n');
    }

    public void lineStart(StringBuilder sb) {
        if (this.border) {
            sb.append(this.unicode ? (char)'\u2502' : '|');
        }
    }

    private String[] computeColLines() {
        int lines = this.widths.length - 1;
        String[] result = new String[lines];
        if (this.columnLineDefault != null) {
            int i = 0;
            while (i < lines) {
                result[i] = this.iColLineStyle(this.columnLineDefault.charValue(), null);
                ++i;
            }
        }
        if (this.columnLines != null) {
            int max = lines;
            if (this.columnLines.length() < max) {
                max = this.columnLines.length();
            }
            int i = 0;
            while (i < max) {
                result[i] = this.iColLineStyle(this.columnLines.charAt(i), result[i]);
                ++i;
            }
        }
        return result;
    }

    private String[] computeRowLines() {
        int lines = this.tabLen - 1;
        String[] result = new String[lines];
        if (this.rowLineDefault != null) {
            int i = 0;
            while (i < lines) {
                result[i] = this.iRowLineStyle(this.rowLineDefault.charValue(), null);
                ++i;
            }
        }
        if (this.rowLines != null) {
            int max = lines;
            if (this.rowLines.length() < max) {
                max = this.rowLines.length();
            }
            int i = 0;
            while (i < max) {
                result[i] = this.iRowLineStyle(this.rowLines.charAt(i), result[i]);
                ++i;
            }
        }
        return result;
    }

    private String iColLineStyle(char c, String def) {
        switch (c) {
            case '.': {
                return def;
            }
            case '|': {
                return this.unicode ? COL_LINE_UNI : COL_LINE_ASC;
            }
            case '!': {
                return this.unicode ? COL_LINE2_UNI : COL_LINE2_ASC;
            }
            case '0': {
                return "";
            }
            case '1': {
                return " ";
            }
            case '2': {
                return "  ";
            }
        }
        throw Err.invalid(Character.valueOf(c));
    }

    private void iComputeLine(StringBuilder sb, char left, char right, char space, char cross1, String cross3) {
        if (this.indent != null) {
            sb.append(this.indent);
        }
        if (this.border) {
            sb.append(left);
        }
        int i = 0;
        while (i < this.widths.length) {
            String colLine;
            if (i != 0 && (colLine = this.xCol[i - 1]) != null) {
                if (colLine.equals(this.unicode ? COL_LINE_UNI : COL_LINE_ASC)) {
                    sb.append(cross1);
                } else if (colLine.equals(this.unicode ? COL_LINE2_UNI : COL_LINE2_ASC)) {
                    sb.append(cross3);
                } else {
                    int t = 0;
                    while (t < colLine.length()) {
                        sb.append(space);
                        ++t;
                    }
                }
            }
            sb.append(Lib_String.sequence(space, (long)this.widths[i]));
            ++i;
        }
        if (this.border) {
            sb.append(right);
        }
    }

    private String iComputeRowLineDouble() {
        if (this.bufferRowLineDouble != null) {
            return this.bufferRowLineDouble;
        }
        StringBuilder sb = new StringBuilder();
        if (this.unicode) {
            this.iComputeLine(sb, '\u255e', '\u2561', '\u2550', '\u256a', "\u2550\u256a\u2550");
        } else {
            this.iComputeLine(sb, '|', '|', '=', '|', "=|=");
        }
        this.bufferRowLineDouble = sb.toString();
        return this.bufferRowLineDouble;
    }

    private String iComputeRowLineEmpty() {
        if (this.bufferRowLineEmpty != null) {
            return this.bufferRowLineEmpty;
        }
        StringBuilder sb = new StringBuilder();
        if (this.unicode) {
            this.iComputeLine(sb, '\u2502', '\u2502', ' ', '\u2502', COL_LINE2_UNI);
        } else {
            this.iComputeLine(sb, '|', '|', ' ', '|', COL_LINE2_ASC);
        }
        this.bufferRowLineEmpty = sb.toString();
        return this.bufferRowLineEmpty;
    }

    private String iComputeRowLineSingle() {
        if (this.bufferRowLineSingle != null) {
            return this.bufferRowLineSingle;
        }
        StringBuilder sb = new StringBuilder();
        if (this.unicode) {
            this.iComputeLine(sb, '\u251c', '\u2524', '\u2500', '\u253c', "\u2500\u253c\u2500");
        } else {
            this.iComputeLine(sb, '|', '|', '-', '|', "-|-");
        }
        this.bufferRowLineSingle = sb.toString();
        return this.bufferRowLineSingle;
    }

    private String iRowLineStyle(char c, String def) {
        switch (c) {
            case '*': {
                return def;
            }
            case '-': {
                return this.iComputeRowLineSingle();
            }
            case '+': {
                return this.iComputeRowLineEmpty();
            }
            case '=': {
                return this.iComputeRowLineDouble();
            }
        }
        throw Err.invalid(Character.valueOf(c));
    }
}

