/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.sort;

import de.mn77.base.data.struct.sort.I_Sortable;
import de.mn77.base.data.struct.sort.I_TableSort;
import de.mn77.base.data.struct.sort.plain.GnomeSort;
import de.mn77.base.data.struct.sort.plain.MergeSort;
import de.mn77.base.data.struct.sort.table.GnomeSortX;
import de.mn77.base.data.struct.sort.table.MergeSortX;
import de.mn77.base.data.util.Lib_Random;
import de.mn77.base.error.Err;
import java.util.Collections;
import java.util.List;

public class Sort {
    private static final GnomeSortX gnomeX = new GnomeSortX();
    private static final MergeSortX mergeX = new MergeSortX();
    private static final GnomeSort gnome = new GnomeSort();
    private static final MergeSort merge = new MergeSort();

    public static <T extends Comparable<? super T>> void list(List<T> list, boolean desc) {
        Collections.sort(list);
        if (desc) {
            Collections.reverse(list);
        }
    }

    public static <T extends Comparable<? super T>> void reverse(List<T> list) {
        Collections.reverse(list);
    }

    public static void sortable(I_Sortable<?> tab, boolean desc) {
        Err.ifNull(tab);
        if (tab.size() <= 10) {
            gnome.sort(tab, desc);
        } else {
            merge.sort(tab, desc);
        }
    }

    public static void sortableRandom(I_Sortable<?> s) {
        if (s.size() <= 1) {
            return;
        }
        int[] rnd = Lib_Random.getIntArraySet(1, s.size());
        s.sortLike(rnd);
    }

    public static void table(I_TableSort<?> tab, int ... relColumnOrder) {
        Err.ifNull(tab);
        if (relColumnOrder == null || relColumnOrder.length == 0) {
            relColumnOrder = Sort.idefaultColumnOrder(tab.width());
        } else {
            int[] nArray = relColumnOrder;
            int n = relColumnOrder.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                Err.ifOutOfBounds(1, tab.width(), Math.abs(i));
                ++n2;
            }
        }
        if (tab.size() <= 10) {
            gnomeX.sort(tab, relColumnOrder);
        } else {
            mergeX.sort(tab, relColumnOrder);
        }
    }

    private static int[] idefaultColumnOrder(int width) {
        int[] columnOrder = new int[width];
        int i = 1;
        while (i <= width) {
            columnOrder[i - 1] = i;
            ++i;
        }
        return columnOrder;
    }
}

