/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.keypot;

import de.mn77.base.data.struct.I_Collection;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.SimpleSet;
import de.mn77.base.data.struct.keypot.A_KeyPot;
import de.mn77.base.data.struct.keypot.I_KeyPot;
import de.mn77.base.error.Err;

public class KeyPotSet<TA, TB>
extends A_KeyPot<TA, TB>
implements I_KeyPot<TA, TB> {
    private final SimpleList<SimpleSet<TB>> pots = new SimpleList();

    @Override
    public void add(TA key, TB object) {
        Integer keyIndex = this.keys.searchFirst(key);
        if (keyIndex == null) {
            this.keys.add(key);
            SimpleSet emptySet = new SimpleSet();
            this.pots.add(emptySet);
            keyIndex = this.keys.searchFirst(key);
        }
        this.pots.get(keyIndex).add(object);
    }

    public void clear(TA key) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            Err.invalid(key, "Invalid Key");
        }
        this.pots.get(index).clear();
    }

    @Override
    public KeyPotSet<TA, TB> copy() {
        throw Err.todo(new Object[0]);
    }

    @Override
    public void exchange(int pos_a, int pos_b) {
        Err.todo(new Object[0]);
    }

    public Object get(int col, int row) {
        if (col == 1) {
            return this.keys.get(row);
        }
        if (col == 2) {
            return this.pots.get(row);
        }
        throw Err.invalid(col);
    }

    @Override
    public SimpleSet<TB> getPot(TA key) {
        Integer index = this.keys.searchFirst(key);
        Err.ifNull((Object)index);
        return this.pots.get(index);
    }

    @Override
    public I_Collection<TB> getPot(TA key, I_Collection<TB> ifMissing) {
        Integer index = this.keys.searchFirst(key);
        if (index == null) {
            return ifMissing;
        }
        return this.pots.get(index);
    }

    public boolean put(TA key, TB object) {
        Integer keyIndex = this.keys.searchFirst(key);
        if (keyIndex == null) {
            this.keys.add(key);
            SimpleSet emptySet = new SimpleSet();
            this.pots.add(emptySet);
            keyIndex = this.keys.searchFirst(key);
        }
        return this.pots.get(keyIndex).add(object);
    }

    public boolean putAll(TA key, Iterable<TB> objects) {
        boolean result = true;
        for (TB o : objects) {
            boolean r = this.put(key, o);
            if (r) continue;
            result = false;
        }
        return result;
    }

    public KeyPotSet<TA, TB> putAllItems(TA key, TB ... objects) {
        TB[] TBArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            TB o = TBArray[n2];
            this.put(key, o);
            ++n2;
        }
        return this;
    }

    @Override
    public SimpleSet<TB> remove(TA key) {
        throw Err.todo(new Object[0]);
    }

    @Override
    public boolean remove(TA key, TB object) {
        Integer index = this.keys.searchFirst(key);
        if (index != null) {
            return this.pots.get(index).remove(object);
        }
        return false;
    }

    @Override
    public void reverse() {
        this.pots.reverse();
    }

    @Override
    public void sortLike(int[] so) {
        Err.todo(new Object[0]);
    }
}

