/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.exceptions.MaryConfigurationException;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.util.data.MaryHeader;

public class HNMFeatureFileReader {
    private MaryHeader hdr = null;
    private HntmSpeechSignal[] hnmSignals;
    private int numberOfUnits = 0;

    public HNMFeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    private void load(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MaryConfigurationException("File [" + fileName + "] was not found.");
        }
        this.hdr = new MaryHeader(dis);
        if (this.hdr.getType() != 325) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary Units file.");
        }
        this.numberOfUnits = dis.readInt();
        if (this.numberOfUnits < 0) {
            throw new MaryConfigurationException("File [" + fileName + "] has a negative number of units. Aborting.");
        }
        this.hnmSignals = new HntmSpeechSignal[this.numberOfUnits];
        int i = 0;
        while (i < this.numberOfUnits) {
            this.hnmSignals[i] = new HntmSpeechSignal(0, 0, 0.0f);
            this.hnmSignals[i].read(dis, 1);
            ++i;
        }
        System.out.println();
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public HntmSpeechSignal getHntmSpeechSignal(int unitnumber) {
        if (unitnumber >= this.numberOfUnits) {
            throw new IllegalArgumentException("the given unit index number(" + unitnumber + ") must be less than number of available units(" + this.numberOfUnits + ")");
        }
        return this.hnmSignals[unitnumber];
    }

    public static void main(String[] args) throws Exception {
        String fileName = "/home/sathish/Work/phd/voices/mlsa-poppy-listener/vocalizations/files/vocalization_hnm_analysis.mry";
        new HNMFeatureFileReader(fileName);
    }
}

