/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.test;

import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.test.BaseTester;
import marytts.signalproc.sinusoidal.test.NoiseTester;
import marytts.signalproc.sinusoidal.test.SinusoidsTester;
import marytts.util.io.FileUtils;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class SinusoidsNoiseTester
extends BaseTester {
    public SinusoidsNoiseTester(SinusoidsTester s, NoiseTester n) {
        assert (s.fs == n.fs);
        this.fs = s.fs;
        int maxLen = 0;
        if (s.signal != null) {
            maxLen = s.signal.length;
        }
        if (n.signal != null && n.signal.length > maxLen) {
            maxLen = n.signal.length;
        }
        this.signal = new double[maxLen];
        this.pitchMarks = null;
        Arrays.fill(this.signal, 0.0);
        if (s.signal != null) {
            int i;
            System.arraycopy(s.signal, 0, this.signal, 0, s.signal.length);
            if (n.signal != null) {
                i = 0;
                while (i < n.signal.length) {
                    int n2 = i;
                    this.signal[n2] = this.signal[n2] + n.signal[i];
                    ++i;
                }
            }
            i = 0;
            while (i < this.signal.length) {
                int n3 = i++;
                this.signal[n3] = this.signal[n3] * 0.5;
            }
            if (s.pitchMarks != null) {
                if (s.pitchMarks[s.pitchMarks.length - 1] >= maxLen - 1) {
                    this.pitchMarks = ArrayUtils.copy(s.pitchMarks);
                    this.f0s = ArrayUtils.copy(s.f0s);
                } else {
                    int maxT0 = SignalProcUtils.time2sample(0.01, this.fs);
                    int pitchMarksLen = s.pitchMarks.length;
                    if (n.pitchMarks != null) {
                        int noiseInd = n.pitchMarks.length - 1;
                        while (n.pitchMarks[noiseInd] - s.pitchMarks[s.pitchMarks.length - 1] > maxT0) {
                            if (--noiseInd >= 0) continue;
                            noiseInd = 0;
                            break;
                        }
                        pitchMarksLen += n.pitchMarks.length - noiseInd;
                        if (noiseInd == 0) {
                            int currInd = n.pitchMarks[0];
                            while (currInd - s.pitchMarks[s.pitchMarks.length - 1] > maxT0) {
                                ++pitchMarksLen;
                                currInd -= maxT0;
                            }
                        }
                        this.pitchMarks = new int[pitchMarksLen];
                        System.arraycopy(s.pitchMarks, 0, this.pitchMarks, 0, s.pitchMarks.length);
                        i = s.pitchMarks.length;
                        while (i < s.pitchMarks.length + n.pitchMarks.length - noiseInd) {
                            this.pitchMarks[i] = n.pitchMarks[i - s.pitchMarks.length + noiseInd];
                            ++i;
                        }
                        i = s.pitchMarks.length + n.pitchMarks.length - noiseInd;
                        while (i < pitchMarksLen) {
                            this.pitchMarks[i] = Math.min(this.pitchMarks[i - 1] + maxT0, maxLen - 1);
                            ++i;
                        }
                    } else {
                        int currInd = s.pitchMarks[s.pitchMarks.length - 1];
                        while (maxLen - currInd > maxT0) {
                            ++pitchMarksLen;
                            currInd += maxT0;
                        }
                        this.pitchMarks = new int[pitchMarksLen];
                        System.arraycopy(s.pitchMarks, 0, this.pitchMarks, 0, s.pitchMarks.length);
                        i = s.pitchMarks.length;
                        while (i < pitchMarksLen) {
                            this.pitchMarks[i] = Math.min(this.pitchMarks[i - 1] + maxT0, maxLen - 1);
                            ++i;
                        }
                        float lastTime = SignalProcUtils.sample2time(this.pitchMarks[this.pitchMarks.length - 1], this.fs);
                        int numfrm = (int)Math.floor(((double)lastTime - 0.5 * (double)this.ws) / (double)this.ss + 0.5);
                        this.f0s = new double[numfrm];
                        System.arraycopy(s.f0s, 0, this.f0s, 0, s.f0s.length);
                        i = s.f0s.length;
                        while (i < numfrm) {
                            this.f0s[i] = 100.0;
                            ++i;
                        }
                    }
                }
            } else {
                int maxT0 = SignalProcUtils.time2sample(0.01, this.fs);
                int numPitchMarks = (int)Math.floor((double)maxLen / (double)maxT0 + 0.5) + 1;
                this.pitchMarks = new int[numPitchMarks];
                i = 0;
                while (i < numPitchMarks) {
                    this.pitchMarks[i] = Math.min(i * maxT0, maxLen - 1);
                    ++i;
                }
                float lastTime = SignalProcUtils.sample2time(this.pitchMarks[this.pitchMarks.length - 1], this.fs);
                int numfrm = (int)Math.floor(((double)lastTime - 0.5 * (double)this.ws) / (double)this.ss + 0.5);
                this.f0s = new double[numfrm];
                Arrays.fill(this.f0s, 100.0);
            }
        } else {
            System.arraycopy(n.signal, 0, this.signal, 0, n.signal.length);
            if (n.pitchMarks != null) {
                this.pitchMarks = ArrayUtils.copy(n.pitchMarks);
                this.f0s = ArrayUtils.copy(n.f0s);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        SinusoidsTester s = null;
        NoiseTester n = null;
        SinusoidsNoiseTester h = null;
        int numSins = 5;
        float[] sinFreqs = new float[numSins];
        sinFreqs[0] = 120.0f;
        sinFreqs[1] = 230.0f;
        sinFreqs[2] = 500.0f;
        sinFreqs[3] = 1100.0f;
        sinFreqs[4] = 1500.0f;
        Sinusoid[] sins = new Sinusoid[numSins];
        int i = 0;
        while (i < numSins) {
            sins[i] = new Sinusoid(100.0f, sinFreqs[i], 0.0f);
            ++i;
        }
        s = new SinusoidsTester(sins);
        int numNoises = 1;
        float[][] freqs = new float[numNoises][];
        float[] amps = new float[numNoises];
        i = 0;
        while (i < numNoises) {
            freqs[i] = new float[2];
            ++i;
        }
        freqs[0][0] = 2000.0f;
        freqs[0][1] = 4000.0f;
        amps[0] = 100.0f;
        n = new NoiseTester((float[][])freqs, amps);
        h = new SinusoidsNoiseTester(s, n);
        if (args.length > 1) {
            h.write(args[0], args[1]);
        } else {
            h.write(args[0]);
        }
        System.out.println(String.valueOf(String.valueOf(MathUtils.getAbsMax(h.signal))) + " " + MathUtils.getAbsMax(s.signal) + " " + MathUtils.getAbsMax(n.signal));
        int[] pitchMarks = FileUtils.readFromBinaryFile(args[1]);
        i = 0;
        while (i < pitchMarks.length) {
            System.out.println(String.valueOf(String.valueOf(pitchMarks[i])) + " ");
            ++i;
        }
    }
}

