/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import marytts.util.math.ArrayUtils;
import marytts.util.signal.SignalProcUtils;

public class HntmSynthesizedSignal {
    public double[] harmonicPart = null;
    public double[] noisePart = null;
    public double[] transientPart = null;
    public double[] output = null;

    public void concatToHarmonicPart(double[] newData) {
        this.harmonicPart = ArrayUtils.combine(this.harmonicPart, newData);
    }

    public void concatToNoisePart(double[] newData) {
        this.noisePart = ArrayUtils.combine(this.noisePart, newData);
    }

    public void concatToTransientPart(double[] newData) {
        this.transientPart = ArrayUtils.combine(this.transientPart, newData);
    }

    public void concat(HntmSynthesizedSignal newSignal) {
        this.concatToHarmonicPart(newSignal.harmonicPart);
        this.concatToNoisePart(newSignal.noisePart);
        this.concatToTransientPart(newSignal.transientPart);
    }

    public void generateOutput() {
        this.output = SignalProcUtils.addSignals(this.harmonicPart, this.noisePart);
        this.output = SignalProcUtils.addSignals(this.output, this.transientPart);
    }
}

